/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;

public abstract class ByteToMessageDecoder
extends ChannelInboundByteHandlerAdapter {
    private volatile boolean singleDecode;
    private boolean decodeWasNull;

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        this.callDecode(ctx, in);
    }

    public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        super.channelReadSuspended(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        if (in.isReadable()) {
            this.callDecode(ctx, in);
        }
        try {
            if (ctx.nextInboundMessageBuffer().unfoldAndAdd(this.decodeLast(ctx, in))) {
                ctx.fireInboundBufferUpdated();
            }
        }
        catch (Throwable t) {
            if (t instanceof CodecException) {
                ctx.fireExceptionCaught(t);
            }
            ctx.fireExceptionCaught((Throwable)new DecoderException(t));
        }
        ctx.fireChannelInactive();
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in) {
        boolean wasNull = false;
        boolean decoded = false;
        MessageBuf out = ctx.nextInboundMessageBuffer();
        while (in.isReadable()) {
            try {
                int oldInputLength = in.readableBytes();
                Object o = this.decode(ctx, in);
                if (o == null) {
                    wasNull = true;
                    if (oldInputLength != in.readableBytes()) continue;
                    break;
                }
                wasNull = false;
                if (oldInputLength == in.readableBytes()) {
                    throw new IllegalStateException("decode() did not read anything but decoded a message.");
                }
                if (!out.unfoldAndAdd(o)) break;
                decoded = true;
                if (!this.isSingleDecode()) continue;
                break;
            }
            catch (Throwable t) {
                if (decoded) {
                    decoded = false;
                    ctx.fireInboundBufferUpdated();
                }
                if (t instanceof CodecException) {
                    ctx.fireExceptionCaught(t);
                    continue;
                }
                ctx.fireExceptionCaught((Throwable)new DecoderException(t));
            }
        }
        if (decoded) {
            this.decodeWasNull = false;
            ctx.fireInboundBufferUpdated();
        } else if (wasNull) {
            this.decodeWasNull = true;
        }
    }

    protected abstract Object decode(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        return this.decode(ctx, in);
    }
}

