/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageDecoder.class, (String)"I");
    }

    protected MessageToMessageDecoder(Class<? extends I> inboundMessageType) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList out = MessageList.newInstance();
        try {
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                if (ctx.isRemoved()) {
                    out.add(msgs, i, size - i);
                    return;
                }
                Object m = msgs.get(i);
                if (this.acceptInboundMessage(m)) {
                    Object cast = m;
                    try {
                        this.decode(ctx, cast, (MessageList<Object>)out);
                        continue;
                    }
                    finally {
                        ByteBufUtil.release((Object)cast);
                    }
                }
                out.add(m);
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            msgs.recycle();
            ctx.fireMessageReceived(out);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, MessageList<Object> var3) throws Exception;
}

