/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.CharsetUtil;

public class HttpUploadClientHandler
extends ChannelInboundMessageHandlerAdapter<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpUploadClientHandler.class);
    private boolean readingChunks;

    public HttpUploadClientHandler() {
        super(new Class[0]);
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.readingChunks) {
            HttpResponse response = (HttpResponse)msg;
            logger.info("STATUS: " + response.getStatus());
            logger.info("VERSION: " + response.getProtocolVersion());
            if (!response.getHeaderNames().isEmpty()) {
                for (String name : response.getHeaderNames()) {
                    for (String value : response.getHeaders(name)) {
                        logger.info("HEADER: " + name + " = " + value);
                    }
                }
            }
            if (response.getStatus().getCode() == 200 && response.getTransferEncoding().isMultiple()) {
                this.readingChunks = true;
                logger.info("CHUNKED CONTENT {");
            } else {
                ByteBuf content = response.getContent();
                if (content.readable()) {
                    logger.info("CONTENT {");
                    logger.info(content.toString(CharsetUtil.UTF_8));
                    logger.info("} END OF CONTENT");
                }
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.isLast()) {
                this.readingChunks = false;
                logger.info("} END OF CHUNKED CONTENT");
            } else {
                logger.info(chunk.getContent().toString(CharsetUtil.UTF_8));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.channel().close();
    }
}

