/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SctpChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSctpChannel;
import io.netty.example.sctp.SctpEchoClientHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NioSctpEchoClient {
    private final String host;
    private final int port;
    private final int firstMessageSize;

    public NioSctpEchoClient(String host, int port, int firstMessageSize) {
        this.host = host;
        this.port = port;
        this.firstMessageSize = firstMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSctpChannel.class).option(ChannelOption.SCTP_NODELAY, (Object)true)).remoteAddress((SocketAddress)new InetSocketAddress(this.host, this.port)).handler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

                public void initChannel(SctpChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new SctpEchoClientHandler(NioSctpEchoClient.this.firstMessageSize)});
                }
            });
            ChannelFuture f = b.connect().sync();
            f.channel().closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: " + NioSctpEchoClient.class.getSimpleName() + " <host> <port> [<first message size>]");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int firstMessageSize = args.length == 3 ? Integer.parseInt(args[2]) : 256;
        new NioSctpEchoClient(host, port, firstMessageSize).run();
    }
}

