/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.codec.socks.SocksCmdRequest;
import io.netty.codec.socks.SocksCmdResponse;
import io.netty.codec.socks.SocksMessage;
import io.netty.example.socksproxy.CallbackNotifier;
import io.netty.example.socksproxy.DirectClientInitializer;
import io.netty.example.socksproxy.RelayHandler;
import io.netty.example.socksproxy.SocksServerUtils;

@ChannelHandler.Sharable
public final class SocksServerConnectHandler
extends ChannelInboundMessageHandlerAdapter<SocksCmdRequest> {
    private static final String name = "SOCKS_SERVER_CONNECT_HANDLER";
    private final Bootstrap b = new Bootstrap();

    public static String getName() {
        return name;
    }

    public SocksServerConnectHandler() {
        super(new Class[]{SocksCmdRequest.class});
    }

    public void messageReceived(final ChannelHandlerContext ctx, final SocksCmdRequest request) throws Exception {
        CallbackNotifier cb = new CallbackNotifier(){

            @Override
            public void onSuccess(final ChannelHandlerContext outboundCtx) {
                ctx.channel().write((Object)new SocksCmdResponse(SocksMessage.CmdStatus.SUCCESS, request.getAddressType())).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        ctx.pipeline().remove(SocksServerConnectHandler.getName());
                        outboundCtx.channel().pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                        ctx.channel().pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundCtx.channel())});
                    }
                });
            }

            @Override
            public void onFailure(ChannelHandlerContext outboundCtx, Throwable cause) {
                ctx.channel().write((Object)new SocksCmdResponse(SocksMessage.CmdStatus.FAILURE, request.getAddressType()));
                SocksServerUtils.closeOnFlush(ctx.channel());
            }
        };
        Channel inboundChannel = ctx.channel();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientInitializer(cb))).remoteAddress(request.getHost(), request.getPort());
        this.b.connect();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

