/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.ocsp;

import io.netty.example.ocsp.Digester;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculator;

public class OcspRequestBuilder {
    private static final SecureRandom GENERATOR = new SecureRandom();
    private SecureRandom generator = GENERATOR;
    private DigestCalculator calculator = Digester.sha1();
    private X509Certificate certificate;
    private X509Certificate issuer;

    public OcspRequestBuilder generator(SecureRandom generator) {
        this.generator = generator;
        return this;
    }

    public OcspRequestBuilder calculator(DigestCalculator calculator) {
        this.calculator = calculator;
        return this;
    }

    public OcspRequestBuilder certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public OcspRequestBuilder issuer(X509Certificate issuer) {
        this.issuer = issuer;
        return this;
    }

    public OCSPReq build() throws OCSPException, IOException, CertificateEncodingException {
        SecureRandom generator = (SecureRandom)ObjectUtil.checkNotNull((Object)this.generator, (String)"generator");
        DigestCalculator calculator = (DigestCalculator)ObjectUtil.checkNotNull((Object)this.calculator, (String)"calculator");
        X509Certificate certificate = (X509Certificate)ObjectUtil.checkNotNull((Object)this.certificate, (String)"certificate");
        X509Certificate issuer = (X509Certificate)ObjectUtil.checkNotNull((Object)this.issuer, (String)"issuer");
        BigInteger serial = certificate.getSerialNumber();
        CertificateID certId = new CertificateID(calculator, new X509CertificateHolder(issuer.getEncoded()), serial);
        OCSPReqBuilder builder = new OCSPReqBuilder();
        builder.addRequest(certId);
        byte[] nonce = new byte[8];
        generator.nextBytes(nonce);
        Extension[] extensions = new Extension[]{new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce))};
        builder.setRequestExtensions(new Extensions(extensions));
        return builder.build();
    }
}

