/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp.multihoming;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.nio.NioSctpChannel;
import io.netty.example.sctp.SctpEchoClientHandler;
import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class SctpMultiHomingEchoClient {
    private static final String CLIENT_PRIMARY_HOST = System.getProperty("host.primary", "127.0.0.1");
    private static final String CLIENT_SECONDARY_HOST = System.getProperty("host.secondary", "127.0.0.2");
    private static final int CLIENT_PORT = Integer.parseInt(System.getProperty("port.local", "8008"));
    private static final String SERVER_REMOTE_HOST = System.getProperty("host.remote", "127.0.0.1");
    private static final int SERVER_REMOTE_PORT = Integer.parseInt(System.getProperty("port.remote", "8007"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSctpChannel.class)).option(SctpChannelOption.SCTP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

                public void initChannel(SctpChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new SctpEchoClientHandler()});
                }
            });
            InetSocketAddress localAddress = SocketUtils.socketAddress((String)CLIENT_PRIMARY_HOST, (int)CLIENT_PORT);
            InetAddress localSecondaryAddress = SocketUtils.addressByName((String)CLIENT_SECONDARY_HOST);
            InetSocketAddress remoteAddress = SocketUtils.socketAddress((String)SERVER_REMOTE_HOST, (int)SERVER_REMOTE_PORT);
            ChannelFuture bindFuture = b.bind((SocketAddress)localAddress).sync();
            SctpChannel channel = (SctpChannel)bindFuture.channel();
            channel.bindAddress(localSecondaryAddress).sync();
            ChannelFuture connectFuture = channel.connect((SocketAddress)remoteAddress).sync();
            connectFuture.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

