/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.util.AttributeKey;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;

public enum StompVersion {
    STOMP_V11("1.1", "v11.stomp"),
    STOMP_V12("1.2", "v12.stomp");

    public static final AttributeKey<StompVersion> CHANNEL_ATTRIBUTE_KEY;
    public static final String SUB_PROTOCOLS;
    private final String version;
    private final String subProtocol;

    private StompVersion(String version, String subProtocol) {
        this.version = version;
        this.subProtocol = subProtocol;
    }

    public String version() {
        return this.version;
    }

    public String subProtocol() {
        return this.subProtocol;
    }

    public static StompVersion findBySubProtocol(String subProtocol) {
        if (subProtocol != null) {
            for (StompVersion stompVersion : StompVersion.values()) {
                if (!stompVersion.subProtocol().equals(subProtocol)) continue;
                return stompVersion;
            }
        }
        throw new IllegalArgumentException("Not found StompVersion for '" + subProtocol + "'");
    }

    static {
        CHANNEL_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"stomp_version");
        ArrayList<String> subProtocols = new ArrayList<String>(StompVersion.values().length);
        for (StompVersion stompVersion : StompVersion.values()) {
            subProtocols.add(stompVersion.subProtocol);
        }
        SUB_PROTOCOLS = StringUtil.join((CharSequence)",", subProtocols).toString();
    }
}

