/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.ArrayDeque;
import java.util.Deque;

public class ChannelFlushFutureNotifier
implements ChannelFutureListener {
    private long writeCounter;
    private final Deque<FlushCheckpoint> flushCheckpoints = new ArrayDeque<FlushCheckpoint>();

    public void addFlushFuture(ChannelFuture future, int pendingDataSize) {
        long checkpoint = this.writeCounter + (long)pendingDataSize;
        if (future instanceof FlushCheckpoint) {
            FlushCheckpoint cp = (FlushCheckpoint)((Object)future);
            cp.flushCheckpoint(checkpoint);
            this.flushCheckpoints.add(cp);
        } else {
            this.flushCheckpoints.add(new DefaultFlushCheckpoint(checkpoint, future));
        }
    }

    public void increaseWriteCounter(long delta) {
        this.writeCounter += delta;
    }

    public void notifyFlushFutures() {
        if (this.flushCheckpoints.isEmpty()) {
            return;
        }
        long writeCounter = this.writeCounter;
        while (true) {
            FlushCheckpoint cp;
            if ((cp = this.flushCheckpoints.peek()) == null) {
                this.writeCounter = 0L;
                break;
            }
            if (cp.flushCheckpoint() > writeCounter) {
                if (writeCounter <= 0L || this.flushCheckpoints.size() != 1) break;
                this.writeCounter = 0L;
                cp.flushCheckpoint(cp.flushCheckpoint() - writeCounter);
                break;
            }
            this.flushCheckpoints.remove();
            cp.future().setSuccess();
        }
        long newWriteCounter = this.writeCounter;
        if (newWriteCounter >= 0x1000000000000000L) {
            this.writeCounter = 0L;
            for (FlushCheckpoint cp : this.flushCheckpoints) {
                cp.flushCheckpoint(cp.flushCheckpoint() - newWriteCounter);
            }
        }
    }

    public void notifyFlushFutures(Throwable cause) {
        FlushCheckpoint cp;
        this.notifyFlushFutures();
        while ((cp = this.flushCheckpoints.poll()) != null) {
            cp.future().setFailure(cause);
        }
    }

    @Override
    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            this.notifyFlushFutures();
        } else {
            this.notifyFlushFutures(future.cause());
        }
    }

    private static class DefaultFlushCheckpoint
    extends FlushCheckpoint {
        private long checkpoint;
        private final ChannelFuture future;

        DefaultFlushCheckpoint(long checkpoint, ChannelFuture future) {
            this.checkpoint = checkpoint;
            this.future = future;
        }

        @Override
        long flushCheckpoint() {
            return this.checkpoint;
        }

        @Override
        void flushCheckpoint(long checkpoint) {
            this.checkpoint = checkpoint;
        }

        @Override
        ChannelFuture future() {
            return this.future;
        }
    }

    static abstract class FlushCheckpoint {
        FlushCheckpoint() {
        }

        abstract long flushCheckpoint();

        abstract void flushCheckpoint(long var1);

        abstract ChannelFuture future();
    }
}

