/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.MessageBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;

abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    protected AbstractNioMessageChannel(Channel parent, Integer id, SelectableChannel ch, int defaultInterestOps) {
        super(parent, id, ch, defaultInterestOps);
    }

    @Override
    protected abstract AbstractNioMessageUnsafe newUnsafe();

    @Override
    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        int writeSpinCount = this.config().getWriteSpinCount() - 1;
        while (!buf.isEmpty()) {
            boolean wrote = false;
            for (int i = writeSpinCount; i >= 0; --i) {
                int localFlushedAmount = this.doWriteMessages(buf, i == 0);
                if (localFlushedAmount <= 0) continue;
                wrote = true;
                break;
            }
            if (wrote) continue;
            break;
        }
    }

    protected abstract int doReadMessages(MessageBuf<Object> var1) throws Exception;

    protected abstract int doWriteMessages(MessageBuf<Object> var1, boolean var2) throws Exception;

    abstract class AbstractNioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        AbstractNioMessageUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            block13: {
                assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
                ChannelPipeline pipeline = AbstractNioMessageChannel.this.pipeline();
                MessageBuf<Object> msgBuf = pipeline.inboundMessageBuffer();
                boolean closed = false;
                boolean read = false;
                try {
                    while (true) {
                        int localReadAmount;
                        if ((localReadAmount = AbstractNioMessageChannel.this.doReadMessages(msgBuf)) > 0) {
                            read = true;
                            continue;
                        }
                        if (localReadAmount == 0) {
                            break block13;
                        }
                        if (localReadAmount < 0) break;
                    }
                    closed = true;
                }
                catch (Throwable t) {
                    if (read) {
                        read = false;
                        pipeline.fireInboundBufferUpdated();
                    }
                    AbstractNioMessageChannel.this.pipeline().fireExceptionCaught(t);
                    if (t instanceof IOException) {
                        this.close(this.voidFuture());
                    }
                }
                finally {
                    if (read) {
                        pipeline.fireInboundBufferUpdated();
                    }
                    if (closed && AbstractNioMessageChannel.this.isOpen()) {
                        this.close(this.voidFuture());
                    }
                }
            }
        }
    }
}

