/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelFuture.Unsafe,
ChannelPromise {
    private final Channel channel;

    public VoidChannelPromise(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<Void>> listener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public ChannelPromise addListeners(GenericFutureListener<? extends Future<Void>> ... listeners) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<Void>> listener) {
        return this;
    }

    @Override
    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<Void>> ... listeners) {
        return this;
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) {
        VoidChannelPromise.fail();
        return false;
    }

    public boolean await(long timeoutMillis) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public ChannelPromise awaitUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        VoidChannelPromise.fail();
        return false;
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isSuccess() {
        return false;
    }

    public Throwable cause() {
        return null;
    }

    @Override
    public ChannelPromise sync() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public ChannelPromise setFailure(Throwable cause) {
        return this;
    }

    @Override
    public ChannelPromise setSuccess() {
        return this;
    }

    public boolean tryFailure(Throwable cause) {
        return false;
    }

    @Override
    public boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public ChannelPromise setSuccess(Void result) {
        return this;
    }

    public boolean trySuccess(Void result) {
        return false;
    }

    public Void getNow() {
        return null;
    }
}

