/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.maven.utils.AntTaskFactory;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public abstract class AbstractLibertySupport
extends AbstractMojo {
    private static final String PROP_RESOLUTION_SYNTAX = "\\$\\{(.+?)\\}";
    private static final Pattern PROP_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project = null;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    protected Settings settings;
    protected AntTaskFactory ant;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}", required=false, readonly=true)
    protected File multiModuleProjectDirectory = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected RepositorySystemSession getRepoSession() {
        return this.repoSession;
    }

    protected void init() throws MojoExecutionException {
        this.ant = AntTaskFactory.forMavenProject(this.getProject());
    }

    protected boolean isReactorMavenProject(org.apache.maven.artifact.Artifact artifact) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(artifact.getGroupId()) || !p.getArtifactId().equals(artifact.getArtifactId()) || !p.getVersion().equals(artifact.getBaseVersion())) continue;
            return true;
        }
        return false;
    }

    protected MavenProject getReactorMavenProject(org.apache.maven.artifact.Artifact artifact) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(artifact.getGroupId()) || !p.getArtifactId().equals(artifact.getArtifactId()) || !p.getVersion().equals(artifact.getBaseVersion())) continue;
            p.setArtifactFilter(new ArtifactFilter(){

                public boolean include(org.apache.maven.artifact.Artifact artifact) {
                    return "compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope());
                }
            });
            return p;
        }
        return null;
    }

    protected String resolvePropertyReferences(String value) {
        String returnValue = value;
        if (value != null) {
            Matcher m = PROP_PATTERN.matcher(value);
            while (m.find()) {
                String varName = m.group(1);
                if (this.project.getProperties().containsKey(varName)) {
                    String replacementValue = this.project.getProperties().getProperty(varName);
                    if (replacementValue == null) continue;
                    returnValue = returnValue.replace("${" + varName + "}", replacementValue);
                    this.getLog().info((CharSequence)("Replaced Liberty configuration property reference ${" + varName + "} with value " + replacementValue));
                    continue;
                }
                this.getLog().debug((CharSequence)("Could not replace property reference: " + varName + " in value: " + value));
            }
        }
        return returnValue;
    }

    protected org.apache.maven.artifact.Artifact getArtifact(Dependency item) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact artifact = this.getResolvedArtifact(item);
        if (artifact == null) {
            throw new MojoExecutionException("Unable to find artifact version of " + item.getGroupId() + ":" + item.getArtifactId() + " in either project dependencies or in project dependencyManagement.");
        }
        return artifact;
    }

    protected org.apache.maven.artifact.Artifact getResolvedArtifact(Dependency item) throws MojoExecutionException {
        assert (item != null);
        org.apache.maven.artifact.Artifact artifact = null;
        if (item.getVersion() != null) {
            artifact = this.createArtifact(item);
        } else {
            artifact = this.resolveFromProjectDependencies(item);
            if (artifact != null) {
                if (!artifact.isResolved()) {
                    item.setVersion(artifact.getVersion());
                    artifact = this.createArtifact(item);
                }
            } else if (this.resolveFromProjectDepMgmt(item) != null) {
                item.setVersion(this.resolveFromProjectDepMgmt(item).getVersion());
                artifact = this.createArtifact(item);
            }
        }
        return artifact;
    }

    protected org.apache.maven.artifact.Artifact getArtifact(String groupId, String artifactId, String type, String version) throws MojoExecutionException {
        return this.getArtifact(groupId, artifactId, type, version, null);
    }

    protected org.apache.maven.artifact.Artifact getArtifact(String groupId, String artifactId, String type, String version, String classifier) throws MojoExecutionException {
        Dependency item = new Dependency();
        item.setGroupId(groupId);
        item.setArtifactId(artifactId);
        item.setType(type);
        item.setVersion(version);
        item.setClassifier(classifier);
        return this.getArtifact(item);
    }

    protected Dependency createArtifactItem(String groupId, String artifactId, String type, String version) {
        return this.getArtifactItem(groupId, artifactId, type, version, null);
    }

    protected Dependency createArtifactItem(String groupId, String artifactId, String type, String version, String classifier) {
        return this.getArtifactItem(groupId, artifactId, type, version, classifier);
    }

    private Dependency getArtifactItem(String groupId, String artifactId, String type, String version, String classifier) {
        Dependency item = new Dependency();
        item.setGroupId(groupId);
        item.setArtifactId(artifactId);
        item.setType(type);
        item.setVersion(version);
        item.setClassifier(classifier);
        return item;
    }

    protected Set<org.apache.maven.artifact.Artifact> getResolvedDependencyWithTransitiveDependencies(String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        HashSet<org.apache.maven.artifact.Artifact> resolvedDependencies = new HashSet<org.apache.maven.artifact.Artifact>();
        if (version != null) {
            org.apache.maven.artifact.Artifact artifact = this.getArtifact(groupId, artifactId, type, version, classifier);
            if (artifact != null) {
                resolvedDependencies.add(artifact);
                this.findTransitiveDependencies(artifact, this.getProject().getArtifacts(), resolvedDependencies);
            } else {
                this.getLog().warn((CharSequence)("Unable to find artifact matching groupId " + groupId + ", artifactId " + artifactId + ", version " + version + ", type " + type + " and classifier " + classifier + " in configured repositories."));
            }
        } else {
            Set artifacts = this.getProject().getArtifacts();
            boolean isWildcard = artifactId != null && artifactId.endsWith("*");
            String compareArtifactId = artifactId;
            boolean isClassifierWildcard = classifier != null && classifier.endsWith("*");
            String compareClassifier = classifier;
            if (isWildcard) {
                if (artifactId.length() == 1) {
                    compareArtifactId = null;
                    isWildcard = false;
                } else {
                    compareArtifactId = artifactId.substring(0, artifactId.length() - 1);
                }
            }
            if (isClassifierWildcard) {
                compareClassifier = classifier.length() == 1 ? null : classifier.substring(0, classifier.length() - 1);
            }
            for (org.apache.maven.artifact.Artifact projectArtifact : artifacts) {
                if (!AbstractLibertySupport.isMatchingProjectDependency(projectArtifact, groupId, isWildcard, compareArtifactId, isClassifierWildcard, compareClassifier)) continue;
                if (!projectArtifact.isResolved()) {
                    Dependency item = this.createArtifactItem(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getType(), projectArtifact.getVersion(), projectArtifact.getClassifier());
                    projectArtifact = this.getArtifact(item);
                }
                if ("test".equals(projectArtifact.getScope())) continue;
                this.getLog().debug((CharSequence)("Found resolved dependency from project dependencies: " + projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId() + ":" + projectArtifact.getVersion()));
                resolvedDependencies.add(projectArtifact);
                this.findTransitiveDependencies(projectArtifact, this.getProject().getArtifacts(), resolvedDependencies);
            }
            if (resolvedDependencies.isEmpty() && this.getProject().getDependencyManagement() != null) {
                List list = this.getProject().getDependencyManagement().getDependencies();
                for (Dependency dependency : list) {
                    Dependency item;
                    org.apache.maven.artifact.Artifact artifact;
                    if (!AbstractLibertySupport.isMatchingProjectDependency(dependency, groupId, isWildcard, compareArtifactId, isClassifierWildcard, compareClassifier) || "test".equals((artifact = this.getArtifact(item = this.createArtifactItem(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getVersion(), dependency.getClassifier()))).getScope())) continue;
                    this.getLog().debug((CharSequence)("Found resolved dependency from project dependencyManagement " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                    resolvedDependencies.add(artifact);
                    this.findTransitiveDependencies(artifact, this.getProject().getArtifacts(), resolvedDependencies);
                }
            }
            if (resolvedDependencies.isEmpty()) {
                this.getLog().warn((CharSequence)("Unable to find artifact matching groupId " + groupId + ", artifactId " + artifactId + " of any version in either project dependencies or in project dependencyManagement (note test-scoped dependencies are excluded)."));
            }
        }
        return resolvedDependencies;
    }

    protected static boolean isMatchingProjectDependency(Dependency dependency, String compareGroupId, boolean isWildcard, String compareArtifactId, boolean isClassifierWildcard, String compareClassifier) {
        return AbstractLibertySupport.isMatchingProjectDependency(dependency.getArtifactId(), dependency.getGroupId(), dependency.getClassifier() != null, dependency.getClassifier(), compareGroupId, isWildcard, compareArtifactId, isClassifierWildcard, compareClassifier);
    }

    protected static boolean isMatchingProjectDependency(org.apache.maven.artifact.Artifact artifact, String compareGroupId, boolean isWildcard, String compareArtifactId, boolean isClassifierWildcard, String compareClassifier) {
        return AbstractLibertySupport.isMatchingProjectDependency(artifact.getArtifactId(), artifact.getGroupId(), artifact.hasClassifier(), artifact.getClassifier(), compareGroupId, isWildcard, compareArtifactId, isClassifierWildcard, compareClassifier);
    }

    protected static boolean isMatchingProjectDependency(String artifactId, String groupId, boolean hasClassifier, String classifier, String compareGroupId, boolean isArtifactIdWildcard, String compareArtifactId, boolean isClassifierWildcard, String compareClassifier) {
        Objects.requireNonNull(artifactId, "artifactId");
        Objects.requireNonNull(groupId, "groupId");
        Objects.requireNonNull(compareGroupId, "compareGroupId");
        if (!groupId.equals(compareGroupId)) {
            return false;
        }
        if (compareArtifactId == null && compareClassifier == null) {
            return true;
        }
        boolean artifactIdMatches = AbstractLibertySupport.isMatchingArtifactId(artifactId, isArtifactIdWildcard, compareArtifactId);
        boolean classifierMatches = AbstractLibertySupport.isMatchingClassifier(hasClassifier, classifier, isClassifierWildcard, compareClassifier);
        return artifactIdMatches && classifierMatches;
    }

    private static boolean isMatchingClassifier(boolean hasClassifier, String classifier, boolean isClassifierWildcard, String compareClassifier) {
        if (isClassifierWildcard && compareClassifier == null) {
            return true;
        }
        if (isClassifierWildcard && hasClassifier && classifier.startsWith(compareClassifier)) {
            return true;
        }
        if (hasClassifier) {
            return classifier.equals(compareClassifier);
        }
        return compareClassifier == null;
    }

    private static boolean isMatchingArtifactId(String artifactId, boolean isArtifactIdWildcard, String compareArtifactId) {
        if (compareArtifactId == null) {
            return true;
        }
        if (isArtifactIdWildcard && artifactId.startsWith(compareArtifactId)) {
            return true;
        }
        return artifactId.equals(compareArtifactId);
    }

    protected void findTransitiveDependencies(org.apache.maven.artifact.Artifact resolvedArtifact, Set<org.apache.maven.artifact.Artifact> resolvedArtifacts, Set<org.apache.maven.artifact.Artifact> resolvedDependencies) {
        boolean isProvidedScopeAllowed = resolvedArtifact.getScope().equals("provided");
        String coords = resolvedArtifact.getGroupId() + ":" + resolvedArtifact.getArtifactId() + ":";
        for (org.apache.maven.artifact.Artifact artifact : resolvedArtifacts) {
            boolean isProvidedScope = artifact.getScope().equals("provided");
            if (artifact.equals(resolvedArtifact) || isProvidedScope && !isProvidedScopeAllowed) continue;
            List depTrail = artifact.getDependencyTrail();
            if (!this.dependencyTrailContainsArtifact(coords, resolvedArtifact.getVersion(), depTrail)) continue;
            this.getLog().info((CharSequence)("Adding transitive dependency with scope: " + artifact.getScope() + " and GAV: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
            resolvedDependencies.add(artifact);
        }
    }

    protected boolean dependencyTrailContainsArtifact(String gaCoords, String version, List<String> depTrail) {
        for (String nextFullArtifactId : depTrail) {
            if (!nextFullArtifactId.startsWith(gaCoords) || version != null && (version == null || !nextFullArtifactId.endsWith(":" + version))) continue;
            return true;
        }
        return false;
    }

    protected org.apache.maven.artifact.Artifact createArtifact(Dependency item) throws MojoExecutionException {
        assert (item != null);
        if (item.getVersion() == null) {
            throw new MojoExecutionException("Unable to find artifact without version specified: " + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " in either project dependencies or in project dependencyManagement.");
        }
        if (item.getVersion().trim().startsWith("[") || item.getVersion().trim().startsWith("(")) {
            try {
                item.setVersion(this.resolveVersionRange(item.getGroupId(), item.getArtifactId(), item.getType(), item.getVersion()));
            }
            catch (VersionRangeResolutionException e) {
                throw new MojoExecutionException("Could not get the highest version from the range: " + item.getVersion(), (Exception)((Object)e));
            }
        }
        return this.resolveArtifactItem(item);
    }

    private org.apache.maven.artifact.Artifact resolveFromProjectDependencies(Dependency item) {
        Set actifacts = this.getProject().getArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : actifacts) {
            if (!artifact.getGroupId().equals(item.getGroupId()) || !artifact.getArtifactId().equals(item.getArtifactId()) || !artifact.getType().equals(item.getType())) continue;
            this.getLog().debug((CharSequence)("Found ArtifactItem from project dependencies: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
            return artifact;
        }
        this.getLog().debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is not found from project dependencies."));
        return null;
    }

    private Dependency resolveFromProjectDepMgmt(Dependency item) {
        if (this.getProject().getDependencyManagement() != null) {
            List list = this.getProject().getDependencyManagement().getDependencies();
            for (Dependency dependency : list) {
                if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
                this.getLog().debug((CharSequence)("Found ArtifactItem from project dependencyManagement " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                return dependency;
            }
        }
        this.getLog().debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is not found from project dependencyManagement."));
        return null;
    }

    private org.apache.maven.artifact.Artifact resolveArtifactItem(Dependency item) throws MojoExecutionException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(item.getGroupId(), item.getArtifactId(), item.getType(), item.getVersion());
        File artifactFile = this.resolveArtifactFile((Artifact)aetherArtifact);
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(item.getGroupId(), item.getArtifactId(), item.getVersion(), "provided", item.getType(), item.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
        if (artifactFile != null && artifactFile.exists()) {
            String pathToLocalArtifact = this.repoSession.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)aetherArtifact);
            File localArtifactFile = new File(this.getRepoSession().getLocalRepository().getBasedir(), pathToLocalArtifact);
            if (localArtifactFile.exists()) {
                artifact.setFile(localArtifactFile);
            } else {
                artifact.setFile(artifactFile);
            }
            artifact.setResolved(true);
            this.getLog().debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is resolved from project repositories."));
        } else {
            this.getLog().warn((CharSequence)("Artifact " + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " has no attached file."));
            artifact.setResolved(false);
        }
        return artifact;
    }

    private File resolveArtifactFile(Artifact aetherArtifact) throws MojoExecutionException {
        ArtifactRequest req = new ArtifactRequest().setRepositories(this.repositories).setArtifact(aetherArtifact);
        ArtifactResult resolutionResult = null;
        try {
            resolutionResult = this.repositorySystem.resolveArtifact(this.repoSession, req);
            if (!resolutionResult.isResolved()) {
                throw new MojoExecutionException("Unable to resolve artifact: " + aetherArtifact.getGroupId() + ":" + aetherArtifact.getArtifactId() + ":" + aetherArtifact.getVersion());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact: " + aetherArtifact.getGroupId() + ":" + aetherArtifact.getArtifactId() + ":" + aetherArtifact.getVersion(), (Exception)((Object)e));
        }
        File artifactFile = resolutionResult.getArtifact().getFile();
        return artifactFile;
    }

    private String resolveVersionRange(String groupId, String artifactId, String extension, String version) throws VersionRangeResolutionException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(groupId, artifactId, extension, version);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)aetherArtifact);
        rangeRequest.setRepositories(this.repositories);
        VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(this.repoSession, rangeRequest);
        if (rangeResult == null || rangeResult.getHighestVersion() == null) {
            throw new VersionRangeResolutionException(rangeResult, "Unable to resolve version range from " + groupId + ":" + artifactId + ":" + extension + ":" + version);
        }
        this.getLog().debug((CharSequence)("Available versions: " + rangeResult.getVersions()));
        return rangeResult.getHighestVersion().toString();
    }

    protected org.apache.maven.artifact.Artifact resolveArtifact(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact resolvedArtifact = artifact;
        if (!artifact.isResolved()) {
            Dependency item = this.createArtifactItem(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion(), artifact.getClassifier());
            resolvedArtifact = this.getArtifact(item);
        }
        return resolvedArtifact;
    }
}

