/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.config.ApplicationXmlDocument;
import io.openliberty.tools.common.plugins.config.ServerConfigDocument;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.PluginConfigXmlDocument;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import io.openliberty.tools.maven.utils.CommonLogger;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class PluginConfigSupport
extends StartDebugMojoSupport {
    protected ServerConfigDocument scd = null;
    @Parameter(property="appsDirectory")
    protected String appsDirectory;
    @Parameter(property="stripVersion", defaultValue="false")
    protected boolean stripVersion;
    @Parameter(property="looseApplication", defaultValue="true")
    protected boolean looseApplication;
    @Parameter(property="deployPackages", defaultValue="project", alias="installAppPackages")
    private String deployPackages;
    @Component
    private BuildContext buildContext;
    protected final String PLUGIN_CONFIG_XML = "liberty-plugin-config.xml";

    @Override
    protected void installServerAssembly() throws MojoExecutionException {
        try {
            File f = this.exportParametersToXml(false);
            super.installServerAssembly();
            this.buildContext.refresh(f);
            this.buildContext.refresh(this.installDirectory);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("Error installing Liberty server.", e);
        }
    }

    protected String getDeployPackages() {
        if ("ear".equals(this.project.getPackaging())) {
            this.deployPackages = "project";
        }
        return this.deployPackages;
    }

    @Override
    protected void copyConfigFiles() throws IOException, MojoExecutionException {
        try {
            super.copyConfigFiles();
            this.exportParametersToXml();
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("Error copying configuration files to Liberty server directory.", e);
        }
    }

    protected File exportParametersToXml() throws IOException, ParserConfigurationException, TransformerException {
        return this.exportParametersToXml(true);
    }

    protected File exportParametersToXml(boolean includeServerInfo) throws IOException, ParserConfigurationException, TransformerException {
        PluginConfigXmlDocument configDocument = PluginConfigXmlDocument.newInstance("liberty-plugin-config");
        configDocument.createElement("installDirectory", this.installDirectory);
        if (this.installType != BasicSupport.InstallType.ALREADY_EXISTS) {
            configDocument.createElement("assemblyArtifact", this.assemblyArtifact);
            configDocument.createElement("assemblyArchive", this.assemblyArchive);
            configDocument.createElement("assemblyInstallDirectory", this.assemblyInstallDirectory);
        }
        configDocument.createElement("refresh", this.refresh);
        configDocument.createElement("install", this.install);
        configDocument.createElement("serverDirectory", this.serverDirectory);
        configDocument.createElement("userDirectory", this.userDirectory);
        configDocument.createElement("serverOutputDirectory", new File(this.outputDirectory, this.serverName));
        configDocument.createElement("serverName", this.serverName);
        List profiles = this.project.getActiveProfiles();
        configDocument.createActiveBuildProfilesElement("activeBuildProfiles", profiles);
        configDocument.createElement("projectType", this.project.getPackaging());
        if (this.project.getParent() != null && !this.project.getParent().getModules().isEmpty()) {
            configDocument.createElement("aggregatorParentId", this.project.getParent().getArtifactId());
            configDocument.createElement("aggregatorParentBasedir", this.project.getParent().getBasedir());
        }
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            configDocument.createElement("projectCompileDependency", artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
        }
        configDocument.createElement("warSourceDirectory", this.getLibertyAssemblyWarSourceDirectory(this.project));
        if (includeServerInfo) {
            configDocument.createElement("configDirectory", this.configDirectory);
            File configFile = this.findConfigFile("server.xml", this.serverXmlFile);
            if (configFile != null) {
                configDocument.createElement("configFile", configFile);
            }
            if (this.combinedBootstrapProperties != null) {
                configDocument.createElement("bootstrapProperties", this.combinedBootstrapProperties);
            } else if (this.bootstrapProperties != null) {
                if (this.bootstrapPropertiesResolved == null) {
                    this.bootstrapPropertiesResolved = this.handleLatePropertyResolution(this.bootstrapProperties);
                }
                configDocument.createElement("bootstrapProperties", this.bootstrapPropertiesResolved);
            } else {
                configFile = this.findConfigFile("bootstrap.properties", this.bootstrapPropertiesFile);
                if (configFile != null) {
                    configDocument.createElement("bootstrapPropertiesFile", configFile);
                }
            }
            if (this.combinedJvmOptions != null) {
                configDocument.createElement("jvmOptions", this.combinedJvmOptions);
            } else if (this.jvmOptions != null) {
                if (this.jvmOptionsResolved == null) {
                    this.jvmOptionsResolved = this.handleLatePropertyResolution(this.jvmOptions);
                }
                List<String> uniqueOptions = this.getUniqueValues(this.jvmOptionsResolved);
                configDocument.createElement("jvmOptions", uniqueOptions);
            } else {
                configFile = this.findConfigFile("jvm.options", this.jvmOptionsFile);
                if (configFile != null) {
                    configDocument.createElement("jvmOptionsFile", configFile);
                }
            }
            if (this.envMavenProps.isEmpty() && (configFile = this.findConfigFile("server.env", this.serverEnvFile)) != null) {
                configDocument.createElement("serverEnv", configFile);
            }
            if (this.isConfigCopied()) {
                configDocument.createElement("appsDirectory", this.getAppsDirectory());
            }
            configDocument.createElement("looseApplication", this.looseApplication);
            configDocument.createElement("stripVersion", this.stripVersion);
            configDocument.createElement("installAppPackages", this.getDeployPackages());
            configDocument.createElement("applicationFilename", this.getApplicationFilename());
            configDocument.createElement("installAppsConfigDropins", ApplicationXmlDocument.getApplicationXmlFile((File)this.serverDirectory));
        }
        File f = new File(this.project.getBuild().getDirectory() + File.separator + "liberty-plugin-config.xml");
        configDocument.writeXMLDocument(f);
        return f;
    }

    protected File findConfigFile(String fileName, File specificFile) {
        if (specificFile != null && specificFile.exists()) {
            return specificFile;
        }
        File f = new File(this.configDirectory, fileName);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected String getApplicationFilename() {
        int versionBeginIndex;
        if ("dependencies".equals(this.getDeployPackages())) {
            return null;
        }
        String name = this.project.getBuild().getFinalName();
        if (this.stripVersion && (versionBeginIndex = this.project.getBuild().getFinalName().lastIndexOf("-" + this.project.getVersion())) != -1) {
            name = this.project.getBuild().getFinalName().substring(0, versionBeginIndex);
        }
        switch (this.project.getPackaging()) {
            case "ear": 
            case "war": 
            case "eba": 
            case "esa": {
                name = name + "." + this.project.getPackaging();
                if (!this.looseApplication) break;
                name = name + ".xml";
                break;
            }
            case "liberty-assembly": {
                File dir = this.getWarSourceDirectory(this.project);
                if (!dir.exists()) break;
                name = name + ".war";
                if (!this.looseApplication) break;
                name = name + ".xml";
                break;
            }
            default: {
                this.getLog().debug((CharSequence)("The project artifact cannot be installed to a Liberty server because " + this.project.getPackaging() + " is not a supported packaging type."));
                name = null;
            }
        }
        return name;
    }

    @Override
    protected String stripVersionFromName(String name, String version) {
        int versionBeginIndex = name.lastIndexOf("-" + version);
        if (versionBeginIndex != -1) {
            return name.substring(0, versionBeginIndex) + name.substring(versionBeginIndex + version.length() + 1);
        }
        return name;
    }

    protected boolean isAppConfiguredInSourceServerXml(String fullyQualifiedFileName, String fileName) {
        Set<String> locations = this.getAppConfigLocationsFromSourceServerXml();
        String string = fullyQualifiedFileName = fullyQualifiedFileName == null ? null : fullyQualifiedFileName.replace("\\", "/");
        if (locations.contains(fileName) || fullyQualifiedFileName != null && locations.contains(fullyQualifiedFileName)) {
            this.getLog().info((CharSequence)("Application configuration is found in server.xml : " + fileName));
            return true;
        }
        this.getLog().info((CharSequence)("Application configuration is not found in server.xml : " + fileName));
        return false;
    }

    protected boolean isAnyAppConfiguredInSourceServerXml() {
        Set<String> locations = this.getAppConfigLocationsFromSourceServerXml();
        if (locations.size() > 0) {
            this.getLog().debug((CharSequence)"Application configuration is found in server.xml.");
            return true;
        }
        return false;
    }

    protected Set<String> getAppConfigLocationsFromSourceServerXml() {
        File serverXML = new File(this.serverDirectory, "server.xml");
        if (serverXML != null && serverXML.exists()) {
            try {
                Map<String, File> libertyDirPropertyFiles = this.getLibertyDirectoryPropertyFiles();
                CommonLogger logger = new CommonLogger(this.getLog());
                this.setLog(logger.getLog());
                this.scd = this.getServerConfigDocument(logger, serverXML, this.configDirectory, this.bootstrapPropertiesFile, this.combinedBootstrapProperties, this.serverEnvFile, false, libertyDirPropertyFiles);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
                this.getLog().debug((Throwable)e);
            }
        }
        return this.scd != null ? this.scd.getLocations() : new HashSet();
    }

    protected ServerConfigDocument getServerConfigDocument(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) throws IOException {
        if (this.scd == null || !this.scd.getServerXML().getCanonicalPath().equals(serverXML.getCanonicalPath())) {
            this.scd = new ServerConfigDocument(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, libertyDirPropertyFiles);
        }
        return this.scd;
    }

    protected String getAppsDirectory() {
        return this.getAppsDirectory(true);
    }

    protected String getAppsDirectory(boolean logDirectory) {
        if (this.appsDirectory != null && !this.appsDirectory.isEmpty()) {
            if ("dropins".equals(this.appsDirectory) || "apps".equals(this.appsDirectory)) {
                return this.appsDirectory;
            }
            this.getLog().warn((CharSequence)MessageFormat.format(messages.getString("warn.invalid.app.directory"), this.appsDirectory));
        }
        this.appsDirectory = "dropins";
        File srcServerXML = this.findConfigFile("server.xml", this.serverXmlFile);
        if (srcServerXML != null && srcServerXML.exists() && this.isAnyAppConfiguredInSourceServerXml()) {
            this.appsDirectory = "apps";
        }
        if (logDirectory) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.default.app.directory"), this.appsDirectory));
        }
        return this.appsDirectory;
    }

    protected File getLibertyAssemblyWarSourceDirectory(MavenProject proj) {
        if ("liberty-assembly".equals(this.project.getPackaging()) && this.looseApplication && (this.getDeployPackages().equals("all") || this.getDeployPackages().equals("project")) || this.project.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null) != null) {
            return this.getWarSourceDirectory(this.project);
        }
        return null;
    }

    protected File getWarSourceDirectory(MavenProject proj) {
        File dirObj;
        String dir = this.getPluginConfiguration(proj, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory");
        this.getLog().debug((CharSequence)String.format("WAR source directory from POM: %s", dir));
        File warSourceDir = dir != null ? ((dirObj = new File(dir)).isAbsolute() ? dirObj : new File(proj.getBasedir(), dir)) : new File(proj.getBasedir(), "src/main/webapp");
        this.getLog().debug((CharSequence)String.format("Final WAR source directory: %s (absolute: %s)", warSourceDir, warSourceDir.getAbsolutePath()));
        return warSourceDir;
    }

    private String getPluginConfiguration(MavenProject proj, String pluginGroupId, String pluginArtifactId, String key) {
        Xpp3Dom val;
        Xpp3Dom dom = proj.getGoalConfiguration(pluginGroupId, pluginArtifactId, null, null);
        if (dom != null && (val = dom.getChild(key)) != null) {
            return val.getValue();
        }
        return null;
    }
}

