/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.jsp;

import io.openliberty.tools.ant.jsp.CompileJSPs;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.maven.InstallFeatureSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="compile-jsp", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CompileJspMojo
extends InstallFeatureSupport {
    @Parameter
    protected String jspVersion;
    @Parameter(defaultValue="40")
    protected int timeout;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping compile-jsp goal.\n");
            return;
        }
        this.doCompileJsps();
    }

    private void doCompileJsps() throws MojoExecutionException {
        CompileJSPs compile = (CompileJSPs)this.ant.createTask("antlib:io/openliberty/tools/ant:compileJSPs");
        if (compile == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "compileJSPs"));
        }
        compile.setInstallDir(this.installDirectory);
        compile.setSrcdir(new File("src/main/webapp"));
        compile.setDestdir(new File(this.getProject().getBuild().getOutputDirectory()));
        compile.setTempdir(new File(this.getProject().getBuild().getDirectory()));
        compile.setTimeout(this.timeout);
        compile.setCleanup(false);
        boolean sourceSet = false;
        List plugins = this.getProject().getBuildPlugins();
        for (Plugin plugin : plugins) {
            Xpp3Dom val;
            Xpp3Dom dom;
            Iterator config;
            if ("org.apache.maven.plugins:maven-compiler-plugin".equals(plugin.getKey())) {
                String value;
                config = plugin.getConfiguration();
                if (!(config instanceof Xpp3Dom)) break;
                dom = (Xpp3Dom)config;
                Xpp3Dom child = dom.getChild("release");
                if (child != null && child.getValue() != null) {
                    value = child.getValue();
                    this.getLog().debug((CharSequence)("compile-jsp using maven.compiler.release value: " + value + " for javaSourceLevel."));
                    compile.setSource(value);
                    sourceSet = true;
                    break;
                }
                child = dom.getChild("source");
                if (child == null || child.getValue() == null) break;
                value = child.getValue();
                this.getLog().debug((CharSequence)("compile-jsp using maven.compiler.source value: " + value + " for javaSourceLevel."));
                compile.setSource(value);
                sourceSet = true;
                break;
            }
            if (!"org.apache.maven.plugins:maven-war-plugin".equals(plugin.getKey()) || !((config = plugin.getConfiguration()) instanceof Xpp3Dom) || (val = (dom = (Xpp3Dom)config).getChild("warSourceDirectory")) == null) continue;
            compile.setSrcdir(new File(val.getValue()));
        }
        if (!sourceSet) {
            String value;
            Properties props = this.getProject().getProperties();
            if (props.containsKey("maven.compiler.release")) {
                value = props.getProperty("maven.compiler.release");
                if (value != null) {
                    this.getLog().debug((CharSequence)("compile-jsp using maven.compiler.release value: " + value + " for javaSourceLevel."));
                    compile.setSource(value);
                    sourceSet = true;
                }
            } else if (props.containsKey("maven.compiler.source") && (value = props.getProperty("maven.compiler.source")) != null) {
                this.getLog().debug((CharSequence)("compile-jsp using maven.compiler.source value: " + value + " for javaSourceLevel."));
                compile.setSource(value);
                sourceSet = true;
            }
        }
        TreeSet<String> classpath = new TreeSet<String>();
        classpath.add(this.getProject().getBuild().getOutputDirectory());
        Set dependencies = this.getProject().getArtifacts();
        for (Artifact dep : dependencies) {
            if (!dep.isResolved()) {
                dep = this.resolveArtifact(dep);
            }
            if (dep.getFile() != null) {
                if (classpath.add(dep.getFile().getAbsolutePath())) continue;
                this.getLog().warn((CharSequence)("Duplicate dependency: " + dep.getId()));
                continue;
            }
            this.getLog().warn((CharSequence)("Could not find: " + dep.getId()));
        }
        String classpathStr = this.join(classpath, File.pathSeparator);
        this.getLog().debug((CharSequence)("Classpath: " + classpathStr));
        compile.setClasspath(classpathStr);
        if (this.initialize()) {
            Set<String> installedFeatures;
            try {
                installedFeatures = this.getSpecifiedFeatures(null);
            }
            catch (PluginExecutionException e) {
                throw new MojoExecutionException("Error getting the list of specified features.", (Exception)((Object)e));
            }
            this.setJspVersion(compile, installedFeatures);
            installedFeatures.remove("jsp-2.3");
            installedFeatures.remove("jsp-2.2");
            if (installedFeatures != null && !installedFeatures.isEmpty()) {
                compile.setFeatures(installedFeatures.toString().replace("[", "").replace("]", ""));
            }
        }
        compile.execute();
    }

    private void setJspVersion(CompileJSPs compile, Set<String> installedFeatures) {
        if (this.jspVersion != null) {
            compile.setJspVersion(this.jspVersion);
        } else {
            for (String currentFeature : installedFeatures) {
                if (!currentFeature.startsWith("jsp-")) continue;
                String version = currentFeature.replace("jsp-", "");
                compile.setJspVersion(version);
                break;
            }
        }
    }

    private String join(Set<String> depPathes, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String str : depPathes) {
            if (sb.length() != 0) {
                sb.append(sep);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    protected void init() throws MojoExecutionException {
        boolean doInstall = this.installDirectory == null;
        super.init();
        if (doInstall) {
            try {
                this.installServerAssembly();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failure installing server", e);
            }
        }
    }
}

