/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.attach.core;

import io.opentelemetry.contrib.attach.core.AgentFileProvider;
import io.opentelemetry.contrib.attach.core.RuntimeAttachException;
import java.io.File;
import java.lang.management.ManagementFactory;
import net.bytebuddy.agent.ByteBuddyAgent;

public final class CoreRuntimeAttach {
    private static final String AGENT_ENABLED_PROPERTY = "otel.javaagent.enabled";
    private static final String AGENT_ENABLED_ENV_VAR = "OTEL_JAVAAGENT_ENABLED";
    static final String MAIN_METHOD_CHECK_PROP = "otel.javaagent.testing.runtime-attach.main-method-check";
    private final String agentJarResourceName;
    private boolean runtimeAttachmentRequested;

    public CoreRuntimeAttach(String agentJarResourceName) {
        this.agentJarResourceName = agentJarResourceName;
    }

    public void attachJavaagentToCurrentJVM() {
        if (!CoreRuntimeAttach.shouldAttach()) {
            return;
        }
        if (this.runtimeAttachmentRequested) {
            return;
        }
        this.runtimeAttachmentRequested = true;
        AgentFileProvider agentFileProvider = new AgentFileProvider(this.agentJarResourceName);
        File javaagentFile = agentFileProvider.getAgentFile();
        try {
            ByteBuddyAgent.attach((File)javaagentFile, (String)CoreRuntimeAttach.getPid());
        }
        catch (RuntimeException e) {
            CoreRuntimeAttach.handleByteBuddyException(e);
        }
        if (!CoreRuntimeAttach.agentIsAttached()) {
            CoreRuntimeAttach.printError("Agent was not attached. An unexpected issue has happened.");
        }
    }

    private static void printError(String message) {
        System.err.println(message);
    }

    private static boolean shouldAttach() {
        if (CoreRuntimeAttach.agentIsDisabledWithProp()) {
            return false;
        }
        if (CoreRuntimeAttach.agentIsDisabledWithEnvVar()) {
            return false;
        }
        if (CoreRuntimeAttach.agentIsAttached()) {
            return false;
        }
        if (CoreRuntimeAttach.mainMethodCheckIsEnabled() && !CoreRuntimeAttach.isMainThread()) {
            CoreRuntimeAttach.printError("Agent is not attached because runtime attachment was not requested from main thread.");
            return false;
        }
        if (CoreRuntimeAttach.mainMethodCheckIsEnabled() && !CoreRuntimeAttach.isMainMethod()) {
            CoreRuntimeAttach.printError("Agent is not attached because runtime attachment was not requested from main method.");
            return false;
        }
        return true;
    }

    private static boolean agentIsDisabledWithProp() {
        String agentEnabledPropValue = System.getProperty(AGENT_ENABLED_PROPERTY);
        return "false".equalsIgnoreCase(agentEnabledPropValue);
    }

    private static boolean agentIsDisabledWithEnvVar() {
        String agentEnabledEnvVarValue = System.getenv(AGENT_ENABLED_ENV_VAR);
        return "false".equals(agentEnabledEnvVarValue);
    }

    private static void handleByteBuddyException(RuntimeException exception) {
        CoreRuntimeAttach.handleNoAgentProvider(exception);
        throw new RuntimeAttachException("A problem has occurred during the runtime attachment of the Java agent.", exception);
    }

    private static void handleNoAgentProvider(RuntimeException exception) {
        String message;
        if (exception instanceof IllegalStateException && (message = exception.getMessage()) != null && message.contains("No compatible attachment provider is available")) {
            throw new RuntimeAttachException("Runtime attachment has failed. Are you using a JRE (not a JDK)?", exception);
        }
    }

    private static boolean agentIsAttached() {
        try {
            Class.forName("io.opentelemetry.javaagent.OpenTelemetryAgent", false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean mainMethodCheckIsEnabled() {
        String mainThreadCheck = System.getProperty(MAIN_METHOD_CHECK_PROP);
        return !"false".equals(mainThreadCheck);
    }

    private static boolean isMainThread() {
        Thread currentThread = Thread.currentThread();
        return "main".equals(currentThread.getName());
    }

    static boolean isMainMethod() {
        StackTraceElement bottomOfStack = CoreRuntimeAttach.findBottomOfStack(Thread.currentThread());
        String methodName = bottomOfStack.getMethodName();
        return "main".equals(methodName);
    }

    private static StackTraceElement findBottomOfStack(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        return stackTrace[stackTrace.length - 1];
    }

    private static String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }
}

