/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExemplarStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.HistogramDataPoint;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.io.IOException;
import java.util.List;

final class HistogramDataPointStatelessMarshaler
implements StatelessMarshaler<HistogramPointData> {
    static final HistogramDataPointStatelessMarshaler INSTANCE = new HistogramDataPointStatelessMarshaler();

    private HistogramDataPointStatelessMarshaler() {
    }

    public void writeTo(Serializer output, HistogramPointData point, MarshalerContext context) throws IOException {
        output.serializeFixed64(HistogramDataPoint.START_TIME_UNIX_NANO, point.getStartEpochNanos());
        output.serializeFixed64(HistogramDataPoint.TIME_UNIX_NANO, point.getEpochNanos());
        output.serializeFixed64(HistogramDataPoint.COUNT, point.getCount());
        output.serializeDoubleOptional(HistogramDataPoint.SUM, point.getSum());
        if (point.hasMin()) {
            output.serializeDoubleOptional(HistogramDataPoint.MIN, point.getMin());
        }
        if (point.hasMax()) {
            output.serializeDoubleOptional(HistogramDataPoint.MAX, point.getMax());
        }
        output.serializeRepeatedFixed64(HistogramDataPoint.BUCKET_COUNTS, point.getCounts());
        output.serializeRepeatedDouble(HistogramDataPoint.EXPLICIT_BOUNDS, point.getBoundaries());
        output.serializeRepeatedMessageWithContext(HistogramDataPoint.EXEMPLARS, point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, context);
        output.serializeRepeatedMessageWithContext(HistogramDataPoint.ATTRIBUTES, point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    public int getBinarySerializedSize(HistogramPointData point, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)HistogramDataPoint.START_TIME_UNIX_NANO, (long)point.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)HistogramDataPoint.TIME_UNIX_NANO, (long)point.getEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)HistogramDataPoint.COUNT, (long)point.getCount());
        size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)HistogramDataPoint.SUM, (double)point.getSum());
        if (point.hasMin()) {
            size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)HistogramDataPoint.MIN, (double)point.getMin());
        }
        if (point.hasMax()) {
            size += MarshalerUtil.sizeDoubleOptional((ProtoFieldInfo)HistogramDataPoint.MAX, (double)point.getMax());
        }
        size += MarshalerUtil.sizeRepeatedFixed64((ProtoFieldInfo)HistogramDataPoint.BUCKET_COUNTS, (List)point.getCounts());
        size += MarshalerUtil.sizeRepeatedDouble((ProtoFieldInfo)HistogramDataPoint.EXPLICIT_BOUNDS, (List)point.getBoundaries());
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)HistogramDataPoint.EXEMPLARS, (List)point.getExemplars(), (StatelessMarshaler)ExemplarStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)HistogramDataPoint.ATTRIBUTES, (Attributes)point.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
    }
}

