/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.grpc.managedchannel.internal;

import io.grpc.Channel;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.grpc.managedchannel.internal.UpstreamGrpcSender;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class UpstreamGrpcSenderProvider
implements GrpcSenderProvider {
    public <T extends Marshaler> GrpcSender<T> createSender(URI endpoint, String endpointPath, boolean compressionEnabled, long timeoutNanos, Supplier<Map<String, List<String>>> headersSupplier, @Nullable Object managedChannel, Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> stubFactory, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        boolean shutdownChannel = false;
        if (managedChannel == null) {
            shutdownChannel = true;
            managedChannel = UpstreamGrpcSenderProvider.minimalFallbackManagedChannel(endpoint);
        }
        String authorityOverride = null;
        Map<String, List<String>> headers = headersSupplier.get();
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                if (!entry.getKey().equals("host") || entry.getValue().isEmpty()) continue;
                authorityOverride = entry.getValue().get(0);
            }
        }
        Codec codec = compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        MarshalerServiceStub stub = (MarshalerServiceStub)stubFactory.get().apply((Channel)managedChannel, authorityOverride).withCompression(codec.getMessageEncoding());
        return new UpstreamGrpcSender(stub, shutdownChannel, timeoutNanos, headersSupplier);
    }

    private static ManagedChannel minimalFallbackManagedChannel(URI endpoint) {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)endpoint.getHost(), (int)endpoint.getPort());
        if (!endpoint.getScheme().equals("https")) {
            channelBuilder.usePlaintext();
        }
        return channelBuilder.build();
    }
}

