/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.incubator.common.ExtendedAttributesBuilder;
import io.opentelemetry.sdk.internal.AttributeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class ExtendedAttributesMap
extends HashMap<ExtendedAttributeKey<?>, Object>
implements ExtendedAttributes {
    private static final long serialVersionUID = -2674974862318200501L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    private ExtendedAttributesMap(long capacity, int lengthLimit) {
        this.capacity = capacity;
        this.lengthLimit = lengthLimit;
    }

    public static ExtendedAttributesMap create(long capacity, int lengthLimit) {
        return new ExtendedAttributesMap(capacity, lengthLimit);
    }

    @Override
    public <T> void put(ExtendedAttributeKey<T> key, T value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return;
        }
        super.put(key, AttributeUtil.applyAttributeLengthLimit(value, this.lengthLimit));
    }

    public int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Nullable
    public <T> T get(ExtendedAttributeKey<T> key) {
        return (T)super.get(key);
    }

    public Map<ExtendedAttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this);
    }

    public ExtendedAttributesBuilder toBuilder() {
        return ExtendedAttributes.builder().putAll((ExtendedAttributes)this);
    }

    @Override
    public void forEach(BiConsumer<? super ExtendedAttributeKey<?>, ? super Object> action) {
        super.forEach(action);
    }

    public Attributes asAttributes() {
        return this.immutableCopy().asAttributes();
    }

    @Override
    public String toString() {
        return "ExtendedAttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    public ExtendedAttributes immutableCopy() {
        return ExtendedAttributes.builder().putAll((ExtendedAttributes)this).build();
    }
}

