/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Otlp;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Zipkin;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SpanExporterFactory
implements Factory<SpanExporter, io.opentelemetry.sdk.trace.export.SpanExporter> {
    private static final SpanExporterFactory INSTANCE = new SpanExporterFactory();

    private SpanExporterFactory() {
    }

    static SpanExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.export.SpanExporter create(@Nullable SpanExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.sdk.trace.export.SpanExporter.composite((io.opentelemetry.sdk.trace.export.SpanExporter[])new io.opentelemetry.sdk.trace.export.SpanExporter[0]);
        }
        Otlp otlpModel = model.getOtlp();
        if (otlpModel != null) {
            return FileConfigUtil.addAndReturn(closeables, SpanExporterFactory.createOtlpExporter(otlpModel, spiHelper));
        }
        if (model.getConsole() != null) {
            return FileConfigUtil.addAndReturn(closeables, SpanExporterFactory.createConsoleExporter(spiHelper));
        }
        Zipkin zipkinModel = model.getZipkin();
        if (zipkinModel != null) {
            return FileConfigUtil.addAndReturn(closeables, SpanExporterFactory.createZipkinExporter(zipkinModel, spiHelper));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized span exporter(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return io.opentelemetry.sdk.trace.export.SpanExporter.composite((io.opentelemetry.sdk.trace.export.SpanExporter[])new io.opentelemetry.sdk.trace.export.SpanExporter[0]);
    }

    private static io.opentelemetry.sdk.trace.export.SpanExporter createOtlpExporter(Otlp model, SpiHelper spiHelper) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (model.getProtocol() != null) {
            properties.put("otel.exporter.otlp.traces.protocol", model.getProtocol());
        }
        if (model.getEndpoint() != null) {
            properties.put("otel.exporter.otlp.endpoint", model.getEndpoint());
        }
        if (model.getHeaders() != null) {
            properties.put("otel.exporter.otlp.traces.headers", model.getHeaders().getAdditionalProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(",")));
        }
        if (model.getCompression() != null) {
            properties.put("otel.exporter.otlp.traces.compression", model.getCompression());
        }
        if (model.getTimeout() != null) {
            properties.put("otel.exporter.otlp.traces.timeout", Integer.toString(model.getTimeout()));
        }
        if (model.getCertificate() != null) {
            properties.put("otel.exporter.otlp.traces.certificate", model.getCertificate());
        }
        if (model.getClientKey() != null) {
            properties.put("otel.exporter.otlp.traces.client.key", model.getClientKey());
        }
        if (model.getClientCertificate() != null) {
            properties.put("otel.exporter.otlp.traces.client.certificate", model.getClientCertificate());
        }
        DefaultConfigProperties configProperties = DefaultConfigProperties.createFromMap(properties);
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.trace.export.SpanExporter)SpanExporterFactory.spanExporterSpiManager((ConfigProperties)configProperties, spiHelper).getByName("otlp"), "otlp exporter");
    }

    private static io.opentelemetry.sdk.trace.export.SpanExporter createConsoleExporter(SpiHelper spiHelper) {
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.trace.export.SpanExporter)SpanExporterFactory.spanExporterSpiManager((ConfigProperties)DefaultConfigProperties.createFromMap(Collections.emptyMap()), spiHelper).getByName("logging"), "logging exporter");
    }

    private static io.opentelemetry.sdk.trace.export.SpanExporter createZipkinExporter(Zipkin model, SpiHelper spiHelper) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (model.getEndpoint() != null) {
            properties.put("otel.exporter.zipkin.endpoint", model.getEndpoint());
        }
        if (model.getTimeout() != null) {
            properties.put("otel.exporter.zipkin.timeout", Integer.toString(model.getTimeout()));
        }
        DefaultConfigProperties configProperties = DefaultConfigProperties.createFromMap(properties);
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.trace.export.SpanExporter)SpanExporterFactory.spanExporterSpiManager((ConfigProperties)configProperties, spiHelper).getByName("zipkin"), "zipkin exporter");
    }

    private static NamedSpiManager<io.opentelemetry.sdk.trace.export.SpanExporter> spanExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableSpanExporterProvider.class, ConfigurableSpanExporterProvider::getName, ConfigurableSpanExporterProvider::createExporter, config);
    }
}

