/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.internal;

import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.sdk.logs.internal.LoggerConfig;

public final class LoggerConfigBuilder {
    private boolean enabled = true;
    private Severity minimumSeverity = Severity.UNDEFINED_SEVERITY_NUMBER;
    private boolean traceBased = false;

    LoggerConfigBuilder() {
    }

    public LoggerConfigBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public LoggerConfigBuilder setMinimumSeverity(Severity minimumSeverity) {
        this.minimumSeverity = minimumSeverity;
        return this;
    }

    public LoggerConfigBuilder setTraceBased(boolean traceBased) {
        this.traceBased = traceBased;
        return this;
    }

    public LoggerConfig build() {
        return LoggerConfig.create(this.enabled, this.minimumSeverity, this.traceBased);
    }
}

