/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import io.opentelemetry.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.Random;
import java.util.function.Supplier;

class RandomFixedSizeExemplarReservoir
extends FixedSizeExemplarReservoir {
    private RandomFixedSizeExemplarReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        super(clock, size, new RandomCellSelector(randomSupplier));
    }

    static RandomFixedSizeExemplarReservoir create(Clock clock, int size, Supplier<Random> randomSupplier) {
        return new RandomFixedSizeExemplarReservoir(clock, size, randomSupplier);
    }

    static class RandomCellSelector
    implements ReservoirCellSelector {
        private final LongAdder numMeasurements = AdderUtil.createLongAdder();
        private final Supplier<Random> randomSupplier;

        private RandomCellSelector(Supplier<Random> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndex(cells);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return this.reservoirCellIndex(cells);
        }

        private int reservoirCellIndex(ReservoirCell[] cells) {
            int count;
            int index = this.randomSupplier.get().nextInt((count = this.numMeasurements.intValue() + 1) > 0 ? count : 1);
            this.numMeasurements.increment();
            if (index < cells.length) {
                return index;
            }
            return -1;
        }

        @Override
        public void reset() {
            this.numMeasurements.reset();
        }
    }
}

