/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.common;

import io.opentracing.contrib.common.Classes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class WrapperProxy {
    public static <T> T wrap(final T obj, final T wrapper) {
        if (obj == null || wrapper == null || obj == wrapper) {
            return wrapper;
        }
        Class<?> objClass = obj.getClass();
        final Class<?> wrapperClass = wrapper.getClass();
        return (T)Proxy.newProxyInstance(objClass.getClassLoader(), Classes.getAllInterfaces(objClass), (InvocationHandler)new WrapperInvocationHandler<T>(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    try {
                        if (method.getDeclaringClass().isAssignableFrom(wrapperClass)) {
                            return method.invoke(wrapper, args);
                        }
                        Method specific = Classes.getDeclaredMethodDeep(wrapperClass, method.getName(), method.getParameterTypes());
                        if (specific != null) {
                            return specific.invoke(wrapper, args);
                        }
                    }
                    catch (IllegalArgumentException specific) {
                        // empty catch block
                    }
                    return method.invoke(obj, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                catch (IllegalAccessException e) {
                    IllegalAccessError error = new IllegalAccessError(e.getMessage());
                    error.setStackTrace(e.getStackTrace());
                    throw error;
                }
            }

            @Override
            public T getObject() {
                return obj;
            }

            @Override
            public T getWrapper() {
                return wrapper;
            }
        });
    }

    public static boolean isWrapper(Object obj) {
        return Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof WrapperInvocationHandler;
    }

    public static <T> boolean isWrapper(T obj, Class<? extends T> wrappedClass) {
        if (!Proxy.isProxyClass(obj.getClass())) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(obj);
        if (!(handler instanceof WrapperInvocationHandler)) {
            return false;
        }
        return wrappedClass.isAssignableFrom(((WrapperInvocationHandler)handler).getWrapper().getClass());
    }

    private WrapperProxy() {
    }

    private static interface WrapperInvocationHandler<T>
    extends InvocationHandler {
        public T getObject();

        public T getWrapper();
    }
}

