/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.JdbcTracing;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.BooleanTag;
import io.opentracing.tag.IntTag;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class JdbcTracingUtils {
    static final String COMPONENT_NAME = "java-jdbc";
    static final StringTag PEER_ADDRESS = new StringTag("peer.address");
    static final BooleanTag SLOW = new BooleanTag("slow");
    static final IntTag SAMPLING_PRIORITY = new IntTag("sampling.priority");

    JdbcTracingUtils() {
    }

    static Span buildSpan(String operationName, String sql, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoreStatements, Tracer tracer) {
        if (!JdbcTracing.isTraceEnabled() || withActiveSpanOnly && tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        if (ignoreStatements != null && ignoreStatements.contains(sql)) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        JdbcTracingUtils.decorate(span, sql, connectionInfo);
        return span;
    }

    static <E extends Exception> void execute(String operationName, CheckedRunnable<E> runnable, String sql, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoreStatements, Tracer tracer) throws E {
        if (!JdbcTracing.isTraceEnabled() || withActiveSpanOnly && tracer.activeSpan() == null) {
            runnable.run();
            return;
        }
        Span span = JdbcTracingUtils.buildSpan(operationName, sql, connectionInfo, withActiveSpanOnly, ignoreStatements, tracer);
        long startTime = JdbcTracing.getSlowQueryThresholdMs() > 0 || JdbcTracing.getExcludeFastQueryThresholdMs() > 0 ? System.nanoTime() : 0L;
        try (Scope ignored = tracer.activateSpan(span);){
            runnable.run();
        }
        catch (Exception e) {
            JdbcTracingUtils.onError(e, span);
            throw e;
        }
        finally {
            JdbcTracingUtils.queryThresholdChecks(span, startTime);
            span.finish();
        }
    }

    /*
     * Exception decompiling
     */
    static <T, E extends Exception> T call(String operationName, CheckedCallable<T, E> callable, String sql, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoreStatements, Tracer tracer) throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isNotEmpty(CharSequence s) {
        return s != null && !"".contentEquals(s);
    }

    private static void decorate(Span span, String sql, ConnectionInfo connectionInfo) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        if (JdbcTracingUtils.isNotEmpty(sql)) {
            Tags.DB_STATEMENT.set(span, sql);
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbType())) {
            Tags.DB_TYPE.set(span, connectionInfo.getDbType());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbPeer())) {
            PEER_ADDRESS.set(span, connectionInfo.getDbPeer());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbInstance())) {
            Tags.DB_INSTANCE.set(span, connectionInfo.getDbInstance());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbUser())) {
            Tags.DB_USER.set(span, connectionInfo.getDbUser());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getPeerService())) {
            Tags.PEER_SERVICE.set(span, connectionInfo.getPeerService());
        }
    }

    static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(JdbcTracingUtils.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(3);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        return errorLogs;
    }

    private static void queryThresholdChecks(Span span, long startTime) {
        long completionTime = System.nanoTime() - startTime;
        if (JdbcTracing.getExcludeFastQueryThresholdMs() > 0 && completionTime < TimeUnit.MILLISECONDS.toNanos(JdbcTracing.getExcludeFastQueryThresholdMs())) {
            SAMPLING_PRIORITY.set(span, Integer.valueOf(0));
        }
        if (JdbcTracing.getSlowQueryThresholdMs() > 0 && completionTime > TimeUnit.MILLISECONDS.toNanos(JdbcTracing.getSlowQueryThresholdMs())) {
            SLOW.set(span, Boolean.valueOf(true));
        }
    }

    @FunctionalInterface
    static interface CheckedCallable<T, E extends Throwable> {
        public T call() throws E;
    }

    @FunctionalInterface
    static interface CheckedRunnable<E extends Throwable> {
        public void run() throws E;
    }
}

