/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.ConnectionURLParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMatcherURLParser
implements ConnectionURLParser {
    private final Pattern pattern;
    private final String dbType;

    public AbstractMatcherURLParser(Pattern pattern, String dbType) {
        this.pattern = pattern;
        this.dbType = dbType;
    }

    protected ConnectionInfo.Builder initBuilder(Matcher matcher) {
        String host = matcher.group("host");
        String port = null;
        try {
            port = matcher.group("port");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ConnectionInfo.Builder builder = port == null || "".equals(port) ? new ConnectionInfo.Builder(host) : new ConnectionInfo.Builder(host, Integer.valueOf(port));
        String instance = ConnectionInfo.UNKNOWN_CONNECTION_INFO.getDbInstance();
        try {
            instance = matcher.group("instance");
            if (instance == null || "".equals(instance)) {
                instance = ConnectionInfo.UNKNOWN_CONNECTION_INFO.getDbInstance();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return builder.dbType(this.dbType).dbInstance(instance);
    }

    @Override
    public ConnectionInfo parse(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (matcher.matches()) {
            return this.initBuilder(matcher).build();
        }
        return ConnectionInfo.UNKNOWN_CONNECTION_INFO;
    }
}

