/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NamedArguments;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.NamedArgumentNode;
import com.mitchellbosecke.pebble.node.Node;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgumentsNode
implements Node {
    private final List<NamedArgumentNode> namedArgs;
    private final List<PositionalArgumentNode> positionalArgs;
    private final int lineNumber;

    public ArgumentsNode(List<PositionalArgumentNode> positionalArgs, List<NamedArgumentNode> namedArgs, int lineNumber) {
        this.positionalArgs = positionalArgs;
        this.namedArgs = namedArgs;
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<NamedArgumentNode> getNamedArgs() {
        return this.namedArgs;
    }

    public List<PositionalArgumentNode> getPositionalArgs() {
        return this.positionalArgs;
    }

    public Map<String, Object> getArgumentMap(PebbleTemplateImpl self, EvaluationContextImpl context, NamedArguments invocableWithNamedArguments) {
        HashMap<String, Object> result;
        block8: {
            List<String> argumentNames;
            block7: {
                result = new HashMap<String, Object>();
                argumentNames = invocableWithNamedArguments.getArgumentNames();
                if (argumentNames != null) break block7;
                if (this.positionalArgs == null || this.positionalArgs.isEmpty()) break block8;
                for (int i = 0; i < this.positionalArgs.size(); ++i) {
                    result.put(String.valueOf(i), this.positionalArgs.get(i).getValueExpression().evaluate(self, context));
                }
                break block8;
            }
            if (this.positionalArgs != null) {
                int nameIndex = 0;
                for (PositionalArgumentNode arg : this.positionalArgs) {
                    if (argumentNames.size() <= nameIndex) {
                        throw new PebbleException(null, "The argument at position " + (nameIndex + 1) + " is not allowed. Only " + argumentNames.size() + " argument(s) are allowed.", this.lineNumber, self.getName());
                    }
                    result.put(argumentNames.get(nameIndex), arg.getValueExpression().evaluate(self, context));
                    ++nameIndex;
                }
            }
            if (this.namedArgs != null) {
                for (NamedArgumentNode arg : this.namedArgs) {
                    if (!argumentNames.contains(arg.getName())) {
                        throw new PebbleException(null, "The following named argument does not exist: " + arg.getName(), this.lineNumber, self.getName());
                    }
                    Object value = arg.getValueExpression() == null ? null : (Object)arg.getValueExpression().evaluate(self, context);
                    result.put(arg.getName(), value);
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.positionalArgs.toString();
    }
}

