/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool.introspection.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import reactor.pool.PoolMetricsRecorder;
import reactor.pool.introspection.micrometer.PoolMetersDocumentation;

final class MicrometerMetricsRecorder
implements PoolMetricsRecorder {
    private final String poolName;
    private final MeterRegistry meterRegistry;
    private final Timer allocationFailureTimer;
    private final Timer allocationSuccessTimer;
    private final Timer destroyedMeter;
    private final Counter recycledCounter;
    private final Counter recycledNotableFastPathCounter;
    private final Counter recycledNotableSlowPathCounter;
    private final Timer resetMeter;
    private final Timer resourceSummaryIdleness;
    private final Timer resourceSummaryLifetime;
    private final Timer pendingSuccessTimer;
    private final Timer pendingFailureTimer;

    MicrometerMetricsRecorder(String poolName, MeterRegistry registry) {
        this.poolName = poolName;
        this.meterRegistry = registry;
        Tags nameTag = Tags.of((String)PoolMetersDocumentation.CommonTags.POOL_NAME.asString(), (String)this.poolName);
        this.allocationSuccessTimer = this.meterRegistry.timer(PoolMetersDocumentation.ALLOCATION.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.AllocationTags.OUTCOME_SUCCESS}));
        this.allocationFailureTimer = this.meterRegistry.timer(PoolMetersDocumentation.ALLOCATION.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.AllocationTags.OUTCOME_FAILURE}));
        this.resetMeter = this.meterRegistry.timer(PoolMetersDocumentation.RESET.getName(), (Iterable)nameTag);
        this.destroyedMeter = this.meterRegistry.timer(PoolMetersDocumentation.DESTROYED.getName(), (Iterable)nameTag);
        this.recycledCounter = this.meterRegistry.counter(PoolMetersDocumentation.RECYCLED.getName(), (Iterable)nameTag);
        this.recycledNotableFastPathCounter = this.meterRegistry.counter(PoolMetersDocumentation.RECYCLED_NOTABLE.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.RecycledNotableTags.PATH_FAST}));
        this.recycledNotableSlowPathCounter = this.meterRegistry.counter(PoolMetersDocumentation.RECYCLED_NOTABLE.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.RecycledNotableTags.PATH_SLOW}));
        this.resourceSummaryLifetime = this.meterRegistry.timer(PoolMetersDocumentation.SUMMARY_LIFETIME.getName(), (Iterable)nameTag);
        this.resourceSummaryIdleness = this.meterRegistry.timer(PoolMetersDocumentation.SUMMARY_IDLENESS.getName(), (Iterable)nameTag);
        this.pendingSuccessTimer = this.meterRegistry.timer(PoolMetersDocumentation.PENDING.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.PendingTags.OUTCOME_SUCCESS}));
        this.pendingFailureTimer = this.meterRegistry.timer(PoolMetersDocumentation.PENDING.getName(), (Iterable)nameTag.and(new Tag[]{PoolMetersDocumentation.PendingTags.OUTCOME_FAILURE}));
    }

    public void recordAllocationSuccessAndLatency(long latencyMs) {
        this.allocationSuccessTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordAllocationFailureAndLatency(long latencyMs) {
        this.allocationFailureTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordResetLatency(long latencyMs) {
        this.resetMeter.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordDestroyLatency(long latencyMs) {
        this.destroyedMeter.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordRecycled() {
        this.recycledCounter.increment();
    }

    public void recordLifetimeDuration(long millisecondsSinceAllocation) {
        this.resourceSummaryLifetime.record(millisecondsSinceAllocation, TimeUnit.MILLISECONDS);
    }

    public void recordIdleTime(long millisecondsIdle) {
        this.resourceSummaryIdleness.record(millisecondsIdle, TimeUnit.MILLISECONDS);
    }

    public void recordSlowPath() {
        this.recycledNotableSlowPathCounter.increment();
    }

    public void recordFastPath() {
        this.recycledNotableFastPathCounter.increment();
    }

    public void recordPendingSuccessAndLatency(long latencyMs) {
        this.pendingSuccessTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordPendingFailureAndLatency(long latencyMs) {
        this.pendingFailureTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }
}

