/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.SocketAddress;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.ConnectionInformation;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.internal.util.MapUtils;

abstract class AbstractAccessLogArgProvider<SELF extends AbstractAccessLogArgProvider<SELF>>
implements AccessLogArgProvider,
Supplier<SELF> {
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z");
    static final String MISSING = "-";
    final @Nullable SocketAddress remoteAddress;
    final String user = "-";
    @Nullable ConnectionInformation connectionInfo;
    @Nullable String zonedDateTime;
    @Nullable ZonedDateTime accessDateTime;
    @Nullable CharSequence method;
    @Nullable CharSequence uri;
    @Nullable String protocol;
    boolean chunked;
    long contentLength = -1L;
    long startTime;
    @Nullable Map<CharSequence, Set<Cookie>> cookies;

    AbstractAccessLogArgProvider(@Nullable SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    AbstractAccessLogArgProvider(AbstractAccessLogArgProvider<?> copy) {
        this.remoteAddress = copy.remoteAddress;
        this.connectionInfo = copy.connectionInfo;
        this.zonedDateTime = copy.zonedDateTime;
        this.accessDateTime = copy.accessDateTime;
        this.method = copy.method;
        this.uri = copy.uri;
        this.protocol = copy.protocol;
        this.chunked = copy.chunked;
        this.contentLength = copy.contentLength;
        this.startTime = copy.startTime;
        if (copy.cookies != null) {
            this.cookies = new HashMap<CharSequence, Set<Cookie>>(MapUtils.calculateInitialCapacity((int)copy.cookies.size()));
            this.cookies.putAll(copy.cookies);
        }
    }

    @Override
    @Deprecated
    public @Nullable String zonedDateTime() {
        return this.zonedDateTime;
    }

    @Override
    public @Nullable ZonedDateTime accessDateTime() {
        return this.accessDateTime;
    }

    @Override
    public @Nullable SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public @Nullable ConnectionInformation connectionInformation() {
        return this.connectionInfo;
    }

    @Override
    public @Nullable CharSequence method() {
        return this.method;
    }

    @Override
    public @Nullable CharSequence uri() {
        return this.uri;
    }

    @Override
    public @Nullable String protocol() {
        return this.protocol;
    }

    @Override
    public @Nullable String user() {
        return MISSING;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public long duration() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public @Nullable Map<CharSequence, Set<Cookie>> cookies() {
        return this.cookies;
    }

    void onRequest() {
        this.accessDateTime = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
        this.zonedDateTime = this.accessDateTime.format(DATE_TIME_FORMATTER);
        this.startTime = System.currentTimeMillis();
    }

    void clear() {
        this.accessDateTime = null;
        this.zonedDateTime = null;
        this.method = null;
        this.uri = null;
        this.protocol = null;
        this.chunked = false;
        this.contentLength = -1L;
        this.startTime = 0L;
        this.cookies = null;
        this.connectionInfo = null;
    }

    SELF cookies(Map<CharSequence, Set<Cookie>> cookies) {
        this.cookies = cookies;
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }

    SELF chunked(boolean chunked) {
        this.chunked = chunked;
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }

    SELF increaseContentLength(long contentLength) {
        if (this.chunked && contentLength >= 0L && !HttpMethod.HEAD.asciiName().contentEqualsIgnoreCase(this.method)) {
            if (this.contentLength == -1L) {
                this.contentLength = 0L;
            }
            this.contentLength += contentLength;
        }
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }

    SELF connectionInformation(ConnectionInformation connectionInfo) {
        this.connectionInfo = connectionInfo;
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }
}

