/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.test.DefaultStepVerifierBuilder;
import reactor.test.StepVerifierOptions;
import reactor.test.scheduler.VirtualTimeScheduler;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.function.Tuple2;

public interface StepVerifier {
    public static final Duration DEFAULT_VERIFY_TIMEOUT = Duration.ZERO;

    public static void setDefaultTimeout(@Nullable Duration timeout) {
        DefaultStepVerifierBuilder.defaultVerifyTimeout = timeout == null ? DEFAULT_VERIFY_TIMEOUT : timeout;
    }

    public static void resetDefaultTimeout() {
        StepVerifier.setDefaultTimeout(null);
    }

    public static <T> FirstStep<T> create(Publisher<? extends T> publisher) {
        return StepVerifier.create(publisher, Long.MAX_VALUE);
    }

    public static <T> FirstStep<T> create(Publisher<? extends T> publisher, long n) {
        return StepVerifier.create(publisher, StepVerifierOptions.create().initialRequest(n));
    }

    public static <T> FirstStep<T> create(Publisher<? extends T> publisher, StepVerifierOptions options) {
        return DefaultStepVerifierBuilder.newVerifier(options, () -> publisher);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier) {
        return StepVerifier.withVirtualTime(scenarioSupplier, Long.MAX_VALUE);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier, long n) {
        return StepVerifier.withVirtualTime(scenarioSupplier, () -> VirtualTimeScheduler.getOrSet(true), n);
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier, Supplier<? extends VirtualTimeScheduler> vtsLookup, long n) {
        return StepVerifier.withVirtualTime(scenarioSupplier, StepVerifierOptions.create().initialRequest(n).virtualTimeSchedulerSupplier(vtsLookup));
    }

    public static <T> FirstStep<T> withVirtualTime(Supplier<? extends Publisher<? extends T>> scenarioSupplier, StepVerifierOptions options) {
        DefaultStepVerifierBuilder.checkPositive(options.getInitialRequest());
        Objects.requireNonNull(scenarioSupplier, "scenarioSupplier");
        if (options.getVirtualTimeSchedulerSupplier() == null) {
            options = options.copy().virtualTimeSchedulerSupplier(() -> VirtualTimeScheduler.getOrSet(true));
        }
        return DefaultStepVerifierBuilder.newVerifier(options, scenarioSupplier);
    }

    public StepVerifier log();

    public StepVerifier verifyLater();

    public Duration verify() throws AssertionError;

    public Duration verify(Duration var1) throws AssertionError;

    public Assertions verifyThenAssertThat();

    public Assertions verifyThenAssertThat(Duration var1);

    public static interface ContextExpectations<T> {
        public ContextExpectations<T> hasKey(Object var1);

        public ContextExpectations<T> hasSize(int var1);

        public ContextExpectations<T> contains(Object var1, Object var2);

        public ContextExpectations<T> containsAllOf(Context var1);

        public ContextExpectations<T> containsAllOf(Map<?, ?> var1);

        public ContextExpectations<T> containsOnly(Context var1);

        public ContextExpectations<T> containsOnly(Map<?, ?> var1);

        public ContextExpectations<T> assertThat(Consumer<Context> var1);

        public ContextExpectations<T> matches(Predicate<Context> var1);

        public ContextExpectations<T> matches(Predicate<Context> var1, String var2);

        public Step<T> then();
    }

    public static interface Assertions {
        public Assertions hasDroppedElements();

        public Assertions hasNotDroppedElements();

        public Assertions hasDropped(Object ... var1);

        public Assertions hasDroppedExactly(Object ... var1);

        public Assertions hasDiscardedElements();

        public Assertions hasNotDiscardedElements();

        public Assertions hasDiscarded(Object ... var1);

        public Assertions hasDiscardedExactly(Object ... var1);

        public Assertions hasDiscardedElementsMatching(Predicate<Collection<Object>> var1);

        public Assertions hasDiscardedElementsSatisfying(Consumer<Collection<Object>> var1);

        public Assertions hasDroppedErrors();

        public Assertions hasNotDroppedErrors();

        public Assertions hasDroppedErrors(int var1);

        public Assertions hasDroppedErrorOfType(Class<? extends Throwable> var1);

        public Assertions hasDroppedErrorMatching(Predicate<Throwable> var1);

        public Assertions hasDroppedErrorWithMessage(String var1);

        public Assertions hasDroppedErrorWithMessageContaining(String var1);

        public Assertions hasDroppedErrorsSatisfying(Consumer<Collection<Throwable>> var1);

        public Assertions hasDroppedErrorsMatching(Predicate<Collection<Throwable>> var1);

        public Assertions hasOperatorErrors();

        public Assertions hasOperatorErrors(int var1);

        public Assertions hasOperatorErrorOfType(Class<? extends Throwable> var1);

        public Assertions hasOperatorErrorMatching(Predicate<Throwable> var1);

        public Assertions hasOperatorErrorWithMessage(String var1);

        public Assertions hasOperatorErrorWithMessageContaining(String var1);

        public Assertions hasOperatorErrorsSatisfying(Consumer<Collection<Tuple2<Optional<Throwable>, Optional<?>>>> var1);

        public Assertions hasOperatorErrorsMatching(Predicate<Collection<Tuple2<Optional<Throwable>, Optional<?>>>> var1);

        public Assertions tookLessThan(Duration var1);

        public Assertions tookMoreThan(Duration var1);
    }

    public static interface FirstStep<T>
    extends Step<T> {
        public Step<T> expectFusion();

        public Step<T> expectFusion(int var1);

        public Step<T> expectFusion(int var1, int var2);

        public Step<T> expectNoFusionSupport();

        public Step<T> expectSubscription();

        public Step<T> expectSubscriptionMatches(Predicate<? super Subscription> var1);
    }

    public static interface Step<T>
    extends LastStep {
        public Step<T> as(String var1);

        public Step<T> consumeNextWith(Consumer<? super T> var1);

        default public Step<T> assertNext(Consumer<? super T> assertionConsumer) {
            return this.consumeNextWith(assertionConsumer);
        }

        public Step<T> consumeRecordedWith(Consumer<? super Collection<T>> var1);

        public Step<T> expectNext(T var1);

        public Step<T> expectNext(T var1, T var2);

        public Step<T> expectNext(T var1, T var2, T var3);

        public Step<T> expectNext(T var1, T var2, T var3, T var4);

        public Step<T> expectNext(T var1, T var2, T var3, T var4, T var5);

        public Step<T> expectNext(T var1, T var2, T var3, T var4, T var5, T var6);

        public Step<T> expectNext(T ... var1);

        public Step<T> expectNextCount(long var1);

        public Step<T> expectNextSequence(Iterable<? extends T> var1);

        public Step<T> expectNextMatches(Predicate<? super T> var1);

        public Step<T> consumeSubscriptionWith(Consumer<? super Subscription> var1);

        public ContextExpectations<T> expectAccessibleContext();

        public Step<T> expectNoAccessibleContext();

        public Step<T> expectNoEvent(Duration var1);

        public Step<T> expectRecordedMatches(Predicate<? super Collection<T>> var1);

        public Step<T> recordWith(Supplier<? extends Collection<T>> var1);

        public Step<T> then(Runnable var1);

        default public Step<T> thenAwait() {
            return this.thenAwait(Duration.ZERO);
        }

        public Step<T> thenAwait(Duration var1);

        public Step<T> thenConsumeWhile(Predicate<T> var1);

        public Step<T> thenConsumeWhile(Predicate<T> var1, Consumer<T> var2);

        public Step<T> thenRequest(long var1);
    }

    public static interface LastStep {
        public StepVerifier consumeErrorWith(Consumer<Throwable> var1);

        public StepVerifier expectError();

        public StepVerifier expectError(Class<? extends Throwable> var1);

        public StepVerifier expectErrorMessage(String var1);

        public StepVerifier expectErrorMatches(Predicate<Throwable> var1);

        public StepVerifier expectErrorSatisfies(Consumer<Throwable> var1);

        public StepVerifier expectTimeout(Duration var1);

        public StepVerifier expectComplete();

        public StepVerifier thenCancel();

        public Duration verifyError();

        public Duration verifyError(Class<? extends Throwable> var1);

        public Duration verifyErrorMessage(String var1);

        public Duration verifyErrorMatches(Predicate<Throwable> var1);

        default public Duration verifyTimeout(Duration duration) {
            return this.expectTimeout(duration).verify();
        }

        public Duration verifyErrorSatisfies(Consumer<Throwable> var1);

        public Duration verifyComplete();
    }
}

