/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Signal;
import reactor.test.ValueFormatters;
import reactor.test.scheduler.VirtualTimeScheduler;
import reactor.util.context.Context;

public class StepVerifierOptions {
    private @Nullable String scenarioName = null;
    private boolean checkUnderRequesting = true;
    private long initialRequest = Long.MAX_VALUE;
    private Supplier<? extends VirtualTimeScheduler> vtsLookup = null;
    private Context initialContext;
    private @Nullable ValueFormatters.ToStringConverter objectFormatter = null;
    final Map<Class<?>, ValueFormatters.Extractor<?>> extractorMap = new LinkedHashMap();

    public static StepVerifierOptions create() {
        return new StepVerifierOptions();
    }

    private StepVerifierOptions() {
    }

    public StepVerifierOptions copy() {
        StepVerifierOptions copy = new StepVerifierOptions();
        copy.scenarioName = this.scenarioName;
        copy.checkUnderRequesting = this.checkUnderRequesting;
        copy.initialRequest = this.initialRequest;
        copy.vtsLookup = this.vtsLookup;
        copy.initialContext = this.initialContext;
        copy.objectFormatter = this.objectFormatter;
        copy.extractorMap.putAll(this.extractorMap);
        return copy;
    }

    public StepVerifierOptions checkUnderRequesting(boolean enabled) {
        this.checkUnderRequesting = enabled;
        return this;
    }

    public boolean isCheckUnderRequesting() {
        return this.checkUnderRequesting;
    }

    public StepVerifierOptions initialRequest(long initialRequest) {
        this.initialRequest = initialRequest;
        return this;
    }

    public long getInitialRequest() {
        return this.initialRequest;
    }

    public StepVerifierOptions valueFormatter(@Nullable ValueFormatters.ToStringConverter valueFormatter) {
        this.objectFormatter = valueFormatter;
        return this;
    }

    public @Nullable ValueFormatters.ToStringConverter getValueFormatter() {
        return this.objectFormatter;
    }

    public <T> StepVerifierOptions extractor(ValueFormatters.Extractor<T> extractor) {
        this.extractorMap.put(extractor.getTargetClass(), extractor);
        return this;
    }

    public Collection<ValueFormatters.Extractor<?>> getExtractors() {
        ArrayList copy = new ArrayList(this.extractorMap.size() + 3);
        copy.addAll(this.extractorMap.values());
        if (!this.extractorMap.containsKey(Signal.class)) {
            copy.add(ValueFormatters.signalExtractor());
        }
        if (!this.extractorMap.containsKey(Iterable.class)) {
            copy.add(ValueFormatters.iterableExtractor());
        }
        if (!this.extractorMap.containsKey(Object[].class)) {
            copy.add(ValueFormatters.arrayExtractor(Object[].class));
        }
        return copy;
    }

    public StepVerifierOptions virtualTimeSchedulerSupplier(Supplier<? extends VirtualTimeScheduler> vtsLookup) {
        this.vtsLookup = vtsLookup;
        return this;
    }

    public @Nullable Supplier<? extends VirtualTimeScheduler> getVirtualTimeSchedulerSupplier() {
        return this.vtsLookup;
    }

    public StepVerifierOptions withInitialContext(Context context) {
        this.initialContext = context;
        return this;
    }

    public @Nullable Context getInitialContext() {
        return this.initialContext;
    }

    public StepVerifierOptions scenarioName(@Nullable String scenarioName) {
        this.scenarioName = scenarioName;
        return this;
    }

    public @Nullable String getScenarioName() {
        return this.scenarioName;
    }
}

