/*
 * Decompiled with CFR 0.152.
 */
package reactor.tools.shaded.net.bytebuddy.implementation.bytecode.member;

import java.util.List;
import reactor.tools.shaded.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import reactor.tools.shaded.net.bytebuddy.implementation.Implementation;
import reactor.tools.shaded.net.bytebuddy.implementation.bytecode.StackManipulation;
import reactor.tools.shaded.net.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import reactor.tools.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import reactor.tools.shaded.net.bytebuddy.utility.JavaConstant;
import reactor.tools.shaded.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class Invokedynamic
extends StackManipulation.AbstractBase {
    private final String name;
    private final JavaConstant.MethodType type;
    private final JavaConstant.MethodHandle bootstrap;
    private final List<? extends JavaConstant> arguments;

    public Invokedynamic(String name, JavaConstant.MethodType type, JavaConstant.MethodHandle bootstrap, List<? extends JavaConstant> arguments) {
        this.name = name;
        this.type = type;
        this.bootstrap = bootstrap;
        this.arguments = arguments;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        Object[] argument = new Object[this.arguments.size()];
        for (int index = 0; index < this.arguments.size(); ++index) {
            argument[index] = this.arguments.get(index).accept(JavaConstantValue.Visitor.INSTANCE);
        }
        methodVisitor.visitInvokeDynamicInsn(this.name, this.type.getDescriptor(), JavaConstantValue.Visitor.INSTANCE.onMethodHandle(this.bootstrap), argument);
        return new StackManipulation.Size(this.type.getReturnType().getStackSize().getSize() - this.type.getParameterTypes().getStackSize(), this.type.getReturnType().getStackSize().getSize());
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.name.equals(((Invokedynamic)object).name)) {
            return false;
        }
        if (!this.type.equals(((Invokedynamic)object).type)) {
            return false;
        }
        if (!this.bootstrap.equals(((Invokedynamic)object).bootstrap)) {
            return false;
        }
        return ((Object)this.arguments).equals(((Invokedynamic)object).arguments);
    }

    public int hashCode() {
        return (((this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + this.type.hashCode()) * 31 + this.bootstrap.hashCode()) * 31 + ((Object)this.arguments).hashCode();
    }
}

