/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.prometheus.metrics.config.ExporterOpenTelemetryProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.exporter.opentelemetry.PrometheusInstrumentationScope;
import io.prometheus.metrics.exporter.opentelemetry.PrometheusMetricProducer;
import io.prometheus.metrics.exporter.opentelemetry.ResourceAttributes;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.CollectionRegistration;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.PeriodicMetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.ResourceBuilder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OpenTelemetryExporter
implements AutoCloseable {
    private final PeriodicMetricReader reader;

    private OpenTelemetryExporter(Builder builder, PrometheusProperties config, PrometheusRegistry registry) {
        OtlpGrpcMetricExporter exporter;
        OtlpGrpcMetricExporterBuilder exporterBuilder;
        InstrumentationScopeInfo instrumentationScopeInfo = PrometheusInstrumentationScope.loadInstrumentationScopeInfo();
        ExporterOpenTelemetryProperties properties = config.getExporterOpenTelemetryProperties();
        Resource resource = this.initResourceAttributes(builder, properties, instrumentationScopeInfo);
        if (ConfigHelper.getProtocol(builder, properties).equals("grpc")) {
            exporterBuilder = OtlpGrpcMetricExporter.builder().setTimeout(Duration.ofSeconds(ConfigHelper.getTimeoutSeconds(builder, properties))).setEndpoint(ConfigHelper.getEndpoint(builder, properties));
            for (Map.Entry header : ConfigHelper.getHeaders(builder, properties).entrySet()) {
                exporterBuilder.addHeader((String)header.getKey(), (String)header.getValue());
            }
            exporter = exporterBuilder.build();
        } else {
            exporterBuilder = OtlpHttpMetricExporter.builder().setTimeout(Duration.ofSeconds(ConfigHelper.getTimeoutSeconds(builder, properties))).setEndpoint(ConfigHelper.getEndpoint(builder, properties));
            for (Map.Entry header : ConfigHelper.getHeaders(builder, properties).entrySet()) {
                exporterBuilder.addHeader((String)header.getKey(), (String)header.getValue());
            }
            exporter = exporterBuilder.build();
        }
        this.reader = PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(Duration.ofSeconds(ConfigHelper.getIntervalSeconds(builder, properties))).build();
        PrometheusMetricProducer prometheusMetricProducer = new PrometheusMetricProducer(registry, instrumentationScopeInfo, resource);
        this.reader.register((CollectionRegistration)prometheusMetricProducer);
    }

    @Override
    public void close() {
        this.reader.shutdown();
    }

    private Resource initResourceAttributes(Builder builder, ExporterOpenTelemetryProperties properties, InstrumentationScopeInfo instrumentationScopeInfo) {
        String serviceName = ConfigHelper.getServiceName(builder, properties);
        String serviceNamespace = ConfigHelper.getServiceNamespace(builder, properties);
        String serviceInstanceId = ConfigHelper.getServiceInstanceId(builder, properties);
        String serviceVersion = ConfigHelper.getServiceVersion(builder, properties);
        Map<String, String> resourceAttributes = ResourceAttributes.get(instrumentationScopeInfo.getName(), serviceName, serviceNamespace, serviceInstanceId, serviceVersion, ConfigHelper.getResourceAttributes(builder, properties));
        ResourceBuilder resourceBuilder = Resource.builder();
        for (Map.Entry<String, String> entry : resourceAttributes.entrySet()) {
            resourceBuilder.put(entry.getKey(), entry.getValue());
        }
        return resourceBuilder.build();
    }

    public static Builder builder() {
        return new Builder(PrometheusProperties.get());
    }

    public static Builder builder(PrometheusProperties config) {
        return new Builder(config);
    }

    public static class Builder {
        private final PrometheusProperties config;
        private PrometheusRegistry registry = null;
        private String protocol;
        private String endpoint;
        private final Map<String, String> headers = new HashMap<String, String>();
        private Integer intervalSeconds;
        private Integer timeoutSeconds;
        private String serviceName;
        private String serviceNamespace;
        private String serviceInstanceId;
        private String serviceVersion;
        private final Map<String, String> resourceAttributes = new HashMap<String, String>();

        private Builder(PrometheusProperties config) {
            this.config = config;
        }

        public Builder registry(PrometheusRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder protocol(String protocol) {
            if (!protocol.equals("grpc") && !protocol.equals("http/protobuf")) {
                throw new IllegalArgumentException(protocol + ": Unsupported protocol. Expecting grpc or http/protobuf");
            }
            this.protocol = protocol;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder intervalSeconds(int intervalSeconds) {
            if (intervalSeconds <= 0) {
                throw new IllegalStateException(intervalSeconds + ": expecting a push interval > 0s");
            }
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public Builder timeoutSeconds(int timeoutSeconds) {
            if (timeoutSeconds <= 0) {
                throw new IllegalStateException(timeoutSeconds + ": expecting a push interval > 0s");
            }
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder resourceAttribute(String name, String value) {
            this.resourceAttributes.put(name, value);
            return this;
        }

        public OpenTelemetryExporter buildAndStart() {
            if (this.registry == null) {
                this.registry = PrometheusRegistry.defaultRegistry;
            }
            return new OpenTelemetryExporter(this, this.config, this.registry);
        }
    }

    private static class ConfigHelper {
        private ConfigHelper() {
        }

        private static String getProtocol(Builder builder, ExporterOpenTelemetryProperties config) {
            String protocol = config.getProtocol();
            if (protocol != null) {
                return protocol;
            }
            protocol = ConfigHelper.getString("otel.exporter.otlp.protocol");
            if (protocol != null) {
                if (!protocol.equals("grpc") && !protocol.equals("http/protobuf")) {
                    throw new IllegalStateException(protocol + ": Unsupported OpenTelemetry exporter protocol. Expecting grpc or http/protobuf.");
                }
                return protocol;
            }
            if (builder.protocol != null) {
                return builder.protocol;
            }
            return "grpc";
        }

        private static String getEndpoint(Builder builder, ExporterOpenTelemetryProperties config) {
            String endpoint = config.getEndpoint();
            if (endpoint == null) {
                endpoint = ConfigHelper.getString("otel.exporter.otlp.metrics.endpoint");
            }
            if (endpoint == null) {
                endpoint = ConfigHelper.getString("otel.exporter.otlp.endpoint");
            }
            if (endpoint == null) {
                endpoint = builder.endpoint;
            }
            if (endpoint == null) {
                endpoint = ConfigHelper.getProtocol(builder, config).equals("grpc") ? "http://localhost:4317" : "http://localhost:4318/v1/metrics";
            }
            if (ConfigHelper.getProtocol(builder, config).equals("grpc")) {
                return endpoint;
            }
            if (!endpoint.endsWith("v1/metrics")) {
                if (!endpoint.endsWith("/")) {
                    return endpoint + "/v1/metrics";
                }
                return endpoint + "v1/metrics";
            }
            return endpoint;
        }

        private static Map<String, String> getHeaders(Builder builder, ExporterOpenTelemetryProperties config) {
            Map<String, String> headers = config.getHeaders();
            if (!headers.isEmpty()) {
                return headers;
            }
            headers = ConfigHelper.getMap("otel.exporter.otlp.headers");
            if (!headers.isEmpty()) {
                return headers;
            }
            if (!builder.headers.isEmpty()) {
                return builder.headers;
            }
            return new HashMap<String, String>();
        }

        private static int getIntervalSeconds(Builder builder, ExporterOpenTelemetryProperties config) {
            Integer intervalSeconds = config.getIntervalSeconds();
            if (intervalSeconds != null) {
                return intervalSeconds;
            }
            intervalSeconds = ConfigHelper.getPositiveInteger("otel.metric.export.interval");
            if (intervalSeconds != null) {
                return (int)TimeUnit.MILLISECONDS.toSeconds(intervalSeconds.intValue());
            }
            if (builder.intervalSeconds != null) {
                return builder.intervalSeconds;
            }
            return 60;
        }

        private static int getTimeoutSeconds(Builder builder, ExporterOpenTelemetryProperties config) {
            Integer timeoutSeconds = config.getTimeoutSeconds();
            if (timeoutSeconds != null) {
                return timeoutSeconds;
            }
            Integer timeoutMilliseconds = ConfigHelper.getPositiveInteger("otel.exporter.otlp.metrics.timeout");
            if (timeoutMilliseconds == null) {
                timeoutMilliseconds = ConfigHelper.getPositiveInteger("otel.exporter.otlp.timeout");
            }
            if (timeoutMilliseconds != null) {
                return (int)TimeUnit.MILLISECONDS.toSeconds(timeoutMilliseconds.intValue());
            }
            if (builder.timeoutSeconds != null) {
                return builder.timeoutSeconds;
            }
            return 10;
        }

        private static String getServiceName(Builder builder, ExporterOpenTelemetryProperties config) {
            String serviceName = config.getServiceName();
            if (serviceName != null) {
                return serviceName;
            }
            serviceName = ConfigHelper.getString("otel.service.name");
            if (serviceName != null) {
                return serviceName;
            }
            if (builder.serviceName != null) {
                return builder.serviceName;
            }
            return null;
        }

        private static String getServiceNamespace(Builder builder, ExporterOpenTelemetryProperties config) {
            String serviceNamespace = config.getServiceNamespace();
            if (serviceNamespace != null) {
                return serviceNamespace;
            }
            if (builder.serviceNamespace != null) {
                return builder.serviceNamespace;
            }
            return null;
        }

        private static String getServiceInstanceId(Builder builder, ExporterOpenTelemetryProperties config) {
            String serviceInstanceId = config.getServiceInstanceId();
            if (serviceInstanceId != null) {
                return serviceInstanceId;
            }
            if (builder.serviceInstanceId != null) {
                return builder.serviceInstanceId;
            }
            return null;
        }

        private static String getServiceVersion(Builder builder, ExporterOpenTelemetryProperties config) {
            String serviceVersion = config.getServiceVersion();
            if (serviceVersion != null) {
                return serviceVersion;
            }
            if (builder.serviceVersion != null) {
                return builder.serviceVersion;
            }
            return null;
        }

        private static Map<String, String> getResourceAttributes(Builder builder, ExporterOpenTelemetryProperties config) {
            Map<String, String> resourceAttributes = config.getResourceAttributes();
            if (!resourceAttributes.isEmpty()) {
                return resourceAttributes;
            }
            resourceAttributes = ConfigHelper.getMap("otel.resource.attributes");
            if (!resourceAttributes.isEmpty()) {
                return resourceAttributes;
            }
            if (!builder.resourceAttributes.isEmpty()) {
                return builder.resourceAttributes;
            }
            return new HashMap<String, String>();
        }

        private static String getString(String otelPropertyName) {
            String otelEnvVarName = otelPropertyName.replace(".", "_").replace("-", "_").toUpperCase();
            if (System.getenv(otelEnvVarName) != null) {
                return System.getenv(otelEnvVarName);
            }
            if (System.getProperty(otelPropertyName) != null) {
                return System.getProperty(otelPropertyName);
            }
            return null;
        }

        private static Integer getInteger(String otelPropertyName) {
            String result = ConfigHelper.getString(otelPropertyName);
            if (result == null) {
                return null;
            }
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(otelPropertyName + "=" + result + " - illegal value.");
            }
        }

        private static Integer getPositiveInteger(String otelPropertyName) {
            Integer result = ConfigHelper.getInteger(otelPropertyName);
            if (result == null) {
                return null;
            }
            if (result <= 0) {
                throw new IllegalStateException(otelPropertyName + "=" + result + ": Expecting value > 0.");
            }
            return result;
        }

        private static Map<String, String> getMap(String otelPropertyName) {
            HashMap<String, String> result = new HashMap<String, String>();
            String property = ConfigHelper.getString(otelPropertyName);
            if (property != null) {
                String[] pairs;
                for (String pair : pairs = property.split(",")) {
                    String[] keyValue;
                    if (!pair.contains("=") || (keyValue = pair.split("=", 1)).length != 2) continue;
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    if (key.length() <= 0 || value.length() <= 0) continue;
                    result.putIfAbsent(key, value);
                }
            }
            return result;
        }
    }
}

