/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import java.util.Properties;

class PrometheusInstrumentationScope {
    private static final String instrumentationScopePropertiesFile = "instrumentationScope.properties";
    private static final String instrumentationScopeNameKey = "instrumentationScope.name";
    private static final String instrumentationScopeVersionKey = "instrumentationScope.version";

    PrometheusInstrumentationScope() {
    }

    public static InstrumentationScopeInfo loadInstrumentationScopeInfo() {
        try {
            Properties properties = new Properties();
            properties.load(PrometheusInstrumentationScope.class.getClassLoader().getResourceAsStream(instrumentationScopePropertiesFile));
            String instrumentationScopeName = properties.getProperty(instrumentationScopeNameKey);
            if (instrumentationScopeName == null) {
                throw new IllegalStateException("Prometheus metrics library initialization error: instrumentationScope.name not found in instrumentationScope.properties in classpath.");
            }
            String instrumentationScopeVersion = properties.getProperty(instrumentationScopeVersionKey);
            if (instrumentationScopeVersion == null) {
                throw new IllegalStateException("Prometheus metrics library initialization error: instrumentationScope.version not found in instrumentationScope.properties in classpath.");
            }
            return InstrumentationScopeInfo.builder((String)instrumentationScopeName).setVersion(instrumentationScopeVersion).build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Prometheus metrics library initialization error: Failed to read instrumentationScope.properties from classpath.", e);
        }
    }
}

