/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.MetricDataFactory;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.CollectionRegistration;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.ResourceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class PrometheusMetricProducer
implements CollectionRegistration {
    private final PrometheusRegistry registry;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;

    public PrometheusMetricProducer(PrometheusRegistry registry, InstrumentationScopeInfo instrumentationScopeInfo, Resource resource) {
        this.registry = registry;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.resource = resource;
    }

    public Collection<MetricData> collectAllMetrics() {
        MetricSnapshots snapshots = this.registry.scrape();
        Resource resourceWithTargetInfo = this.resource.merge(this.resourceFromTargetInfo(snapshots));
        InstrumentationScopeInfo scopeFromInfo = this.instrumentationScopeFromOTelScopeInfo(snapshots);
        ArrayList<MetricData> result = new ArrayList<MetricData>(snapshots.size());
        MetricDataFactory factory = new MetricDataFactory(resourceWithTargetInfo, scopeFromInfo != null ? scopeFromInfo : this.instrumentationScopeInfo, System.currentTimeMillis());
        for (MetricSnapshot snapshot : snapshots) {
            if (snapshot instanceof CounterSnapshot) {
                this.addUnlessNull(result, factory.create((CounterSnapshot)snapshot));
                continue;
            }
            if (snapshot instanceof GaugeSnapshot) {
                this.addUnlessNull(result, factory.create((GaugeSnapshot)snapshot));
                continue;
            }
            if (snapshot instanceof HistogramSnapshot) {
                if (((HistogramSnapshot)snapshot).isGaugeHistogram()) continue;
                this.addUnlessNull(result, factory.create((HistogramSnapshot)snapshot));
                continue;
            }
            if (snapshot instanceof SummarySnapshot) {
                this.addUnlessNull(result, factory.create((SummarySnapshot)snapshot));
                continue;
            }
            if (snapshot instanceof InfoSnapshot) {
                String name = snapshot.getMetadata().getPrometheusName();
                if (name.equals("target") || name.equals("otel_scope")) continue;
                this.addUnlessNull(result, factory.create((InfoSnapshot)snapshot));
                continue;
            }
            if (snapshot instanceof StateSetSnapshot) {
                this.addUnlessNull(result, factory.create((StateSetSnapshot)snapshot));
                continue;
            }
            if (!(snapshot instanceof UnknownSnapshot)) continue;
            this.addUnlessNull(result, factory.create((UnknownSnapshot)snapshot));
        }
        return result;
    }

    private Resource resourceFromTargetInfo(MetricSnapshots snapshots) {
        ResourceBuilder result = Resource.builder();
        for (MetricSnapshot snapshot : snapshots) {
            InfoSnapshot targetInfo;
            if (!snapshot.getMetadata().getName().equals("target") || !(snapshot instanceof InfoSnapshot) || (targetInfo = (InfoSnapshot)snapshot).getDataPoints().size() <= 0) continue;
            InfoSnapshot.InfoDataPointSnapshot data = (InfoSnapshot.InfoDataPointSnapshot)targetInfo.getDataPoints().get(0);
            Labels labels = data.getLabels();
            for (int i = 0; i < labels.size(); ++i) {
                result.put(labels.getName(i), labels.getValue(i));
            }
        }
        return result.build();
    }

    private InstrumentationScopeInfo instrumentationScopeFromOTelScopeInfo(MetricSnapshots snapshots) {
        for (MetricSnapshot snapshot : snapshots) {
            InfoSnapshot scopeInfo;
            if (!snapshot.getMetadata().getPrometheusName().equals("otel_scope") || !(snapshot instanceof InfoSnapshot) || (scopeInfo = (InfoSnapshot)snapshot).getDataPoints().size() <= 0) continue;
            Labels labels = ((InfoSnapshot.InfoDataPointSnapshot)scopeInfo.getDataPoints().get(0)).getLabels();
            String name = null;
            String version = null;
            AttributesBuilder attributesBuilder = Attributes.builder();
            for (int i = 0; i < labels.size(); ++i) {
                if (labels.getPrometheusName(i).equals("otel_scope_name")) {
                    name = labels.getValue(i);
                    continue;
                }
                if (labels.getPrometheusName(i).equals("otel_scope_version")) {
                    version = labels.getValue(i);
                    continue;
                }
                attributesBuilder.put(labels.getName(i), labels.getValue(i));
            }
            if (name == null) continue;
            return InstrumentationScopeInfo.builder(name).setVersion(version).setAttributes(attributesBuilder.build()).build();
        }
        return null;
    }

    private void addUnlessNull(List<MetricData> result, MetricData data) {
        if (data != null) {
            result.add(data);
        }
    }
}

