/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.DoublePointDataImpl;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.DoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.MetricDataType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.SumData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class PrometheusCounter
extends PrometheusData<DoublePointData>
implements SumData<DoublePointData> {
    private final List<DoublePointData> points;

    public PrometheusCounter(CounterSnapshot snapshot, long currentTimeMillis) {
        super(MetricDataType.DOUBLE_SUM);
        this.points = snapshot.getDataPoints().stream().map(dataPoint -> this.toOtelDataPoint((CounterSnapshot.CounterDataPointSnapshot)dataPoint, currentTimeMillis)).collect(Collectors.toList());
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    @Override
    public AggregationTemporality getAggregationTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public Collection<DoublePointData> getPoints() {
        return this.points;
    }

    private DoublePointData toOtelDataPoint(CounterSnapshot.CounterDataPointSnapshot dataPoint, long currentTimeMillis) {
        return new DoublePointDataImpl(dataPoint.getValue(), this.getStartEpochNanos((DataPointSnapshot)dataPoint), this.getEpochNanos((DataPointSnapshot)dataPoint, currentTimeMillis), this.labelsToAttributes(dataPoint.getLabels()), this.convertExemplar(dataPoint.getExemplar()));
    }
}

