/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.GlobalOpenTelemetry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.internal.ConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.ExporterBuilderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.TlsConfigHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.compression.Compressor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.http.HttpExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.http.HttpSender;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.http.HttpSenderProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.export.ProxyOptions;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class HttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    public static final long DEFAULT_CONNECT_TIMEOUT_SECS = 10L;
    private static final Logger LOGGER = Logger.getLogger(HttpExporterBuilder.class.getName());
    private final String exporterName;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    @Nullable
    private Compressor compressor;
    private long connectTimeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    @Nullable
    private ProxyOptions proxyOptions;
    private boolean exportAsJson = false;
    private final Map<String, String> constantHeaders = new HashMap<String, String>();
    private Supplier<Map<String, String>> headerSupplier = Collections::emptyMap;
    private TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy = RetryPolicy.getDefault();
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;

    public HttpExporterBuilder(String exporterName, String type, String defaultEndpoint) {
        this.exporterName = exporterName;
        this.type = type;
        this.endpoint = defaultEndpoint;
    }

    public HttpExporterBuilder<T> setTimeout(long timeout2, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout2);
        return this;
    }

    public HttpExporterBuilder<T> setConnectTimeout(long timeout2, TimeUnit unit) {
        this.connectTimeoutNanos = unit.toNanos(timeout2);
        return this;
    }

    public HttpExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri = ExporterBuilderUtil.validateEndpoint(endpoint);
        this.endpoint = uri.toString();
        return this;
    }

    public HttpExporterBuilder<T> setCompression(@Nullable Compressor compressor) {
        this.compressor = compressor;
        return this;
    }

    public HttpExporterBuilder<T> addConstantHeaders(String key, String value) {
        this.constantHeaders.put(key, value);
        return this;
    }

    public HttpExporterBuilder<T> setHeadersSupplier(Supplier<Map<String, String>> headerSupplier) {
        this.headerSupplier = headerSupplier;
        return this;
    }

    public HttpExporterBuilder<T> setTrustManagerFromCerts(byte[] trustedCertificatesPem) {
        this.tlsConfigHelper.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public HttpExporterBuilder<T> setKeyManagerFromCerts(byte[] privateKeyPem, byte[] certificatePem) {
        this.tlsConfigHelper.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public HttpExporterBuilder<T> setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.tlsConfigHelper.setSslContext(sslContext, trustManager);
        return this;
    }

    public HttpExporterBuilder<T> setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        this.meterProviderSupplier = meterProviderSupplier;
        return this;
    }

    public HttpExporterBuilder<T> setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public HttpExporterBuilder<T> setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpExporterBuilder<T> exportAsJson() {
        this.exportAsJson = true;
        return this;
    }

    public HttpExporterBuilder<T> copy() {
        HttpExporterBuilder<T> copy = new HttpExporterBuilder<T>(this.exporterName, this.type, this.endpoint);
        copy.endpoint = this.endpoint;
        copy.timeoutNanos = this.timeoutNanos;
        copy.connectTimeoutNanos = this.connectTimeoutNanos;
        copy.exportAsJson = this.exportAsJson;
        copy.compressor = this.compressor;
        copy.constantHeaders.putAll(this.constantHeaders);
        copy.headerSupplier = this.headerSupplier;
        copy.tlsConfigHelper = this.tlsConfigHelper.copy();
        if (this.retryPolicy != null) {
            copy.retryPolicy = this.retryPolicy.toBuilder().build();
        }
        copy.meterProviderSupplier = this.meterProviderSupplier;
        copy.proxyOptions = this.proxyOptions;
        return copy;
    }

    public HttpExporter<T> build() {
        Supplier<Map<String, List<String>>> headerSupplier = () -> {
            HashMap result = new HashMap();
            Map<String, String> supplierResult = this.headerSupplier.get();
            if (supplierResult != null) {
                supplierResult.forEach((key, value) -> result.put(key, Collections.singletonList(value)));
            }
            this.constantHeaders.forEach((key, value) -> result.merge(key, Collections.singletonList(value), (v1, v2) -> {
                ArrayList merged = new ArrayList(v1);
                merged.addAll(v2);
                return merged;
            }));
            return result;
        };
        boolean isPlainHttp = this.endpoint.startsWith("http://");
        HttpSenderProvider httpSenderProvider = HttpExporterBuilder.resolveHttpSenderProvider();
        HttpSender httpSender = httpSenderProvider.createSender(this.endpoint, this.compressor, this.exportAsJson, this.exportAsJson ? "application/json" : "application/x-protobuf", this.timeoutNanos, this.connectTimeoutNanos, headerSupplier, this.proxyOptions, this.retryPolicy, isPlainHttp ? null : this.tlsConfigHelper.getSslContext(), isPlainHttp ? null : this.tlsConfigHelper.getTrustManager());
        LOGGER.log(Level.FINE, "Using HttpSender: " + httpSender.getClass().getName());
        return new HttpExporter(this.exporterName, this.type, httpSender, this.meterProviderSupplier, this.exportAsJson);
    }

    public String toString(boolean includePrefixAndSuffix) {
        StringJoiner joiner = includePrefixAndSuffix ? new StringJoiner(", ", "HttpExporterBuilder{", "}") : new StringJoiner(", ");
        joiner.add("exporterName=" + this.exporterName);
        joiner.add("type=" + this.type);
        joiner.add("endpoint=" + this.endpoint);
        joiner.add("timeoutNanos=" + this.timeoutNanos);
        joiner.add("proxyOptions=" + this.proxyOptions);
        joiner.add("compressorEncoding=" + (String)Optional.ofNullable(this.compressor).map(Compressor::getEncoding).orElse(null));
        joiner.add("connectTimeoutNanos=" + this.connectTimeoutNanos);
        joiner.add("exportAsJson=" + this.exportAsJson);
        StringJoiner headersJoiner = new StringJoiner(", ", "Headers{", "}");
        this.constantHeaders.forEach((key, value) -> headersJoiner.add(key + "=OBFUSCATED"));
        Map<String, String> headers = this.headerSupplier.get();
        if (headers != null) {
            headers.forEach((key, value) -> headersJoiner.add(key + "=OBFUSCATED"));
        }
        joiner.add("headers=" + headersJoiner);
        if (this.retryPolicy != null) {
            joiner.add("retryPolicy=" + this.retryPolicy);
        }
        return joiner.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private static HttpSenderProvider resolveHttpSenderProvider() {
        HashMap<String, HttpSenderProvider> httpSenderProviders = new HashMap<String, HttpSenderProvider>();
        for (HttpSenderProvider spi : ServiceLoader.load(HttpSenderProvider.class, HttpExporterBuilder.class.getClassLoader())) {
            httpSenderProviders.put(spi.getClass().getName(), spi);
        }
        if (httpSenderProviders.isEmpty()) {
            throw new IllegalStateException("No HttpSenderProvider found on classpath. Please add dependency on opentelemetry-exporter-sender-okhttp or opentelemetry-exporter-sender-jdk");
        }
        if (httpSenderProviders.size() == 1) {
            return (HttpSenderProvider)httpSenderProviders.values().stream().findFirst().get();
        }
        String configuredSender = ConfigUtil.getString("io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.http.HttpSenderProvider", "");
        if (configuredSender.isEmpty()) {
            LOGGER.log(Level.WARNING, "Multiple HttpSenderProvider found. Please include only one, or specify preference setting io.opentelemetry.exporter.internal.http.HttpSenderProvider to the FQCN of the preferred provider.");
            return (HttpSenderProvider)httpSenderProviders.values().stream().findFirst().get();
        }
        if (httpSenderProviders.containsKey(configuredSender)) {
            return (HttpSenderProvider)httpSenderProviders.get(configuredSender);
        }
        throw new IllegalStateException("No HttpSenderProvider matched configured io.opentelemetry.exporter.internal.http.HttpSenderProvider: " + configuredSender);
    }
}

