/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.StatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.StatelessMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.metrics.ExemplarMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.proto.metrics.v1.internal.Exemplar;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.LongExemplarData;
import java.io.IOException;

final class ExemplarStatelessMarshaler
implements StatelessMarshaler<ExemplarData> {
    static final ExemplarStatelessMarshaler INSTANCE = new ExemplarStatelessMarshaler();

    private ExemplarStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, ExemplarData exemplar, MarshalerContext context) throws IOException {
        output.serializeFixed64(Exemplar.TIME_UNIX_NANO, exemplar.getEpochNanos());
        ProtoFieldInfo valueField = ExemplarMarshaler.toProtoExemplarValueType(exemplar);
        if (valueField == Exemplar.AS_INT) {
            output.serializeFixed64Optional(valueField, ((LongExemplarData)exemplar).getValue());
        } else {
            output.serializeDoubleOptional(valueField, ((DoubleExemplarData)exemplar).getValue());
        }
        SpanContext spanContext = exemplar.getSpanContext();
        if (spanContext.isValid()) {
            output.serializeSpanId(Exemplar.SPAN_ID, spanContext.getSpanId(), context);
            output.serializeTraceId(Exemplar.TRACE_ID, spanContext.getTraceId(), context);
        }
        output.serializeRepeatedMessageWithContext(Exemplar.FILTERED_ATTRIBUTES, exemplar.getFilteredAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }

    @Override
    public int getBinarySerializedSize(ExemplarData exemplar, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Exemplar.TIME_UNIX_NANO, exemplar.getEpochNanos());
        ProtoFieldInfo valueField = ExemplarMarshaler.toProtoExemplarValueType(exemplar);
        size = valueField == Exemplar.AS_INT ? (size += MarshalerUtil.sizeFixed64Optional(valueField, ((LongExemplarData)exemplar).getValue())) : (size += MarshalerUtil.sizeDoubleOptional(valueField, ((DoubleExemplarData)exemplar).getValue()));
        SpanContext spanContext = exemplar.getSpanContext();
        if (spanContext.isValid()) {
            size += MarshalerUtil.sizeSpanId(Exemplar.SPAN_ID, spanContext.getSpanId());
            size += MarshalerUtil.sizeTraceId(Exemplar.TRACE_ID, spanContext.getTraceId());
        }
        return size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Exemplar.FILTERED_ATTRIBUTES, exemplar.getFilteredAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
    }
}

