/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.otlp.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.grpc.GrpcExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.grpc.GrpcExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.traces.SpanReusableDataMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.data.SpanData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final SpanReusableDataMarshaler marshaler;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new SpanReusableDataMarshaler(memoryMode, delegate::export);
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder(this.builder.copy(), this.marshaler.getMemoryMode());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.marshaler.export(spans);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

