/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.resources.Resource;
import java.util.Locale;
import javax.annotation.Nullable;

public final class OsResource {
    private static final AttributeKey<String> OS_DESCRIPTION = AttributeKey.stringKey("os.description");
    private static final AttributeKey<String> OS_TYPE = AttributeKey.stringKey("os.type");
    private static final Resource INSTANCE = OsResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (SecurityException t) {
            return Resource.empty();
        }
        if (os == null) {
            return Resource.empty();
        }
        AttributesBuilder attributes = Attributes.builder();
        String osName = OsResource.getOs(os);
        if (osName != null) {
            attributes.put(OS_TYPE, osName);
        }
        String version = null;
        try {
            version = System.getProperty("os.version");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String osDescription = version != null ? os + ' ' + version : os;
        attributes.put(OS_DESCRIPTION, osDescription);
        return Resource.create(attributes.build(), "https://opentelemetry.io/schemas/1.24.0");
    }

    @Nullable
    private static String getOs(String os) {
        if ((os = os.toLowerCase(Locale.ROOT)).startsWith("windows")) {
            return "windows";
        }
        if (os.startsWith("linux")) {
            return "linux";
        }
        if (os.startsWith("mac")) {
            return "darwin";
        }
        if (os.startsWith("freebsd")) {
            return "freebsd";
        }
        if (os.startsWith("netbsd")) {
            return "netbsd";
        }
        if (os.startsWith("openbsd")) {
            return "openbsd";
        }
        if (os.startsWith("dragonflybsd")) {
            return "dragonflybsd";
        }
        if (os.startsWith("hp-ux")) {
            return "hpux";
        }
        if (os.startsWith("aix")) {
            return "aix";
        }
        if (os.startsWith("solaris")) {
            return "solaris";
        }
        if (os.startsWith("z/os")) {
            return "z_os";
        }
        return null;
    }

    private OsResource() {
    }

    private static final class OsTypeValues {
        static final String WINDOWS = "windows";
        static final String LINUX = "linux";
        static final String DARWIN = "darwin";
        static final String FREEBSD = "freebsd";
        static final String NETBSD = "netbsd";
        static final String OPENBSD = "openbsd";
        static final String DRAGONFLYBSD = "dragonflybsd";
        static final String HPUX = "hpux";
        static final String AIX = "aix";
        static final String SOLARIS = "solaris";
        static final String Z_OS = "z_os";

        private OsTypeValues() {
        }
    }
}

