/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.AttributeNameValueModel;
import java.io.Closeable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class AttributeListFactory
implements Factory<List<AttributeNameValueModel>, Attributes> {
    private static final AttributeListFactory INSTANCE = new AttributeListFactory();

    private AttributeListFactory() {
    }

    static AttributeListFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Attributes create(List<AttributeNameValueModel> model, SpiHelper spiHelper, List<Closeable> closeables) {
        AttributesBuilder builder = Attributes.builder();
        for (AttributeNameValueModel nameValueModel : model) {
            AttributeListFactory.addToBuilder(nameValueModel, builder);
        }
        return builder.build();
    }

    private static void addToBuilder(AttributeNameValueModel nameValueModel, AttributesBuilder builder) {
        String name = FileConfigUtil.requireNonNull(nameValueModel.getName(), "attribute name");
        Object value = FileConfigUtil.requireNonNull(nameValueModel.getValue(), "attribute value");
        AttributeNameValueModel.Type type = nameValueModel.getType();
        if (type == null) {
            type = AttributeNameValueModel.Type.STRING;
        }
        switch (type) {
            case STRING: {
                if (!(value instanceof String)) break;
                builder.put(name, (String)value);
                return;
            }
            case BOOL: {
                if (!(value instanceof Boolean)) break;
                builder.put(name, (boolean)((Boolean)value));
                return;
            }
            case INT: {
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                builder.put(name, ((Number)value).longValue());
                return;
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                builder.put(name, ((Number)value).doubleValue());
                return;
            }
            case STRING_ARRAY: {
                List<String> stringList = AttributeListFactory.checkListOfType(value, String.class);
                if (stringList == null) break;
                builder.put(AttributeKey.stringArrayKey(name), stringList);
                return;
            }
            case BOOL_ARRAY: {
                List<Boolean> boolList = AttributeListFactory.checkListOfType(value, Boolean.class);
                if (boolList == null) break;
                builder.put(AttributeKey.booleanArrayKey(name), boolList);
                return;
            }
            case INT_ARRAY: {
                List<Long> longList = AttributeListFactory.checkListOfType(value, Long.class);
                if (longList != null) {
                    builder.put(AttributeKey.longArrayKey(name), longList);
                    return;
                }
                List<Integer> intList = AttributeListFactory.checkListOfType(value, Integer.class);
                if (intList == null) break;
                builder.put(AttributeKey.longArrayKey(name), intList.stream().map(i -> (long)i).collect(Collectors.toList()));
                return;
            }
            case DOUBLE_ARRAY: {
                List<Double> doubleList = AttributeListFactory.checkListOfType(value, Double.class);
                if (doubleList != null) {
                    builder.put(AttributeKey.doubleArrayKey(name), doubleList);
                    return;
                }
                List<Float> floatList = AttributeListFactory.checkListOfType(value, Float.class);
                if (floatList == null) break;
                builder.put(AttributeKey.doubleArrayKey(name), floatList.stream().map(i -> i.floatValue()).collect(Collectors.toList()));
                return;
            }
        }
        throw new ConfigurationException("Error processing attribute with name \"" + name + "\": value did not match type " + type.name());
    }

    @Nullable
    private static <T> List<T> checkListOfType(Object value, Class<T> expectedType) {
        if (!(value instanceof List)) {
            return null;
        }
        List list = (List)value;
        if (list.isEmpty()) {
            return null;
        }
        if (!list.stream().allMatch(entry -> expectedType.isAssignableFrom(entry.getClass()))) {
            return null;
        }
        return (List)value;
    }
}

