/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SpanExporterFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.BatchSpanProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SimpleSpanProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.BatchSpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.BatchSpanProcessorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.SimpleSpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SpanProcessorFactory
implements Factory<SpanProcessorModel, SpanProcessor> {
    private static final SpanProcessorFactory INSTANCE = new SpanProcessorFactory();

    private SpanProcessorFactory() {
    }

    static SpanProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanProcessor create(SpanProcessorModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        BatchSpanProcessorModel batchModel = model.getBatch();
        if (batchModel != null) {
            SpanExporterModel exporterModel = FileConfigUtil.requireNonNull(batchModel.getExporter(), "batch span processor exporter");
            SpanExporter spanExporter = SpanExporterFactory.getInstance().create(exporterModel, spiHelper, closeables);
            BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder(spanExporter);
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return FileConfigUtil.addAndReturn(closeables, builder.build());
        }
        SimpleSpanProcessorModel simpleModel = model.getSimple();
        if (simpleModel != null) {
            SpanExporterModel exporterModel = FileConfigUtil.requireNonNull(simpleModel.getExporter(), "simple span processor exporter");
            SpanExporter spanExporter = SpanExporterFactory.getInstance().create(exporterModel, spiHelper, closeables);
            return FileConfigUtil.addAndReturn(closeables, SimpleSpanProcessor.create(spanExporter));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple span processors set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry processorKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing processor. This is a programming error."));
            SpanProcessor spanProcessor = FileConfigUtil.loadComponent(spiHelper, SpanProcessor.class, (String)processorKeyValue.getKey(), processorKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, spanProcessor);
        }
        throw new ConfigurationException("span processor must be set");
    }
}

