/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.AggregationFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.IncludeExcludeModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.StreamModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.View;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.ViewBuilder;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

final class ViewFactory
implements Factory<StreamModel, View> {
    private static final ViewFactory INSTANCE = new ViewFactory();

    private ViewFactory() {
    }

    static ViewFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public View create(StreamModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        IncludeExcludeModel attributeKeys;
        ViewBuilder builder = View.builder();
        if (model.getName() != null) {
            builder.setName(model.getName());
        }
        if (model.getDescription() != null) {
            builder.setDescription(model.getDescription());
        }
        if ((attributeKeys = model.getAttributeKeys()) != null) {
            ViewFactory.addAttributeKeyFilter(builder, attributeKeys.getIncluded(), attributeKeys.getExcluded());
        }
        if (model.getAggregation() != null) {
            builder.setAggregation(AggregationFactory.getInstance().create(model.getAggregation(), spiHelper, closeables));
        }
        return builder.build();
    }

    private static void addAttributeKeyFilter(ViewBuilder builder, @Nullable List<String> included, @Nullable List<String> excluded) {
        if (included == null && excluded == null) {
            return;
        }
        if (included == null) {
            HashSet<String> excludedKeys = new HashSet<String>(excluded);
            builder.setAttributeFilter(attributeKey -> !excludedKeys.contains(attributeKey));
            return;
        }
        if (excluded == null) {
            HashSet<String> includedKeys = new HashSet<String>(included);
            builder.setAttributeFilter(includedKeys);
            return;
        }
        HashSet<String> includedKeys = new HashSet<String>(included);
        excluded.forEach(includedKeys::remove);
        builder.setAttributeFilter(includedKeys);
    }
}

