/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.logs.ExtendedLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.logs.LogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.logs.Logger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.logs.LoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.logs.LoggerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.logs.SdkLogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.logs.internal.LoggerConfig;

final class SdkLogger
implements ExtendedLogger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get("noop");
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final boolean loggerEnabled;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerEnabled = loggerConfig.isEnabled();
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerEnabled) {
            return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public boolean isEnabled() {
        return this.loggerEnabled;
    }
}

