/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.metrics.ExtendedDoubleHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.metrics.LongHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.internal.ThrottlingLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.SdkLongHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkDoubleHistogram
extends AbstractInstrument
implements ExtendedDoubleHistogram {
    private static final Logger logger = Logger.getLogger(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final SdkMeter sdkMeter;
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
        if (value < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.sdkMeter.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleHistogramBuilder
    implements ExtendedDoubleHistogramBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleHistogramBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, sdkMeter);
        }

        @Override
        public DoubleHistogramBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleHistogram(x$0, x$1, x$2));
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }

        @Override
        public DoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                ExplicitBucketHistogramUtils.validateBucketBoundaries(bucketBoundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(bucketBoundaries);
            return this;
        }

        @Override
        public ExtendedDoubleHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

