/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.internal.ThrottlingLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.internal.ThrowableUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.export.RegisteredReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class CallbackRegistration {
    private static final Logger logger = Logger.getLogger(CallbackRegistration.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final List<SdkObservableMeasurement> observableMeasurements;
    private final Runnable callback;
    private final List<InstrumentDescriptor> instrumentDescriptors;
    private final boolean hasStorages;

    private CallbackRegistration(List<SdkObservableMeasurement> observableMeasurements, Runnable callback) {
        this.observableMeasurements = observableMeasurements;
        this.callback = callback;
        this.instrumentDescriptors = observableMeasurements.stream().map(SdkObservableMeasurement::getInstrumentDescriptor).collect(Collectors.toList());
        if (this.instrumentDescriptors.size() == 0) {
            throw new IllegalStateException("Callback with no instruments is not allowed");
        }
        this.hasStorages = observableMeasurements.stream().flatMap(measurement -> measurement.getStorages().stream()).findAny().isPresent();
    }

    public static CallbackRegistration create(List<SdkObservableMeasurement> observableMeasurements, Runnable runnable2) {
        return new CallbackRegistration(observableMeasurements, runnable2);
    }

    public String toString() {
        return "CallbackRegistration{instrumentDescriptors=" + this.instrumentDescriptors + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeCallback(RegisteredReader reader, long startEpochNanos, long epochNanos) {
        if (!this.hasStorages) {
            return;
        }
        this.observableMeasurements.forEach(observableMeasurement -> observableMeasurement.setActiveReader(reader, startEpochNanos, epochNanos));
        try {
            this.callback.run();
        }
        catch (Throwable e) {
            ThrowableUtil.propagateIfFatal(e);
            this.throttlingLogger.log(Level.WARNING, "An exception occurred invoking callback for " + this + ".", e);
        }
        finally {
            this.observableMeasurements.forEach(SdkObservableMeasurement::unsetActiveReader);
        }
    }
}

