/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state.DebugUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state.MetricStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetricStorageRegistry {
    private static final Logger logger = Logger.getLogger(MetricStorageRegistry.class.getName());
    private final Object lock = new Object();
    private final Map<MetricDescriptor, MetricStorage> registry = new HashMap<MetricDescriptor, MetricStorage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MetricStorage> getStorages() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<MetricStorage>(this.registry.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends MetricStorage> I register(I newStorage) {
        ArrayList<MetricStorage> storages;
        MetricStorage oldOrNewStorage;
        MetricDescriptor descriptor = newStorage.getMetricDescriptor();
        Iterator iterator2 = this.lock;
        synchronized (iterator2) {
            oldOrNewStorage = this.registry.computeIfAbsent(descriptor, key -> newStorage);
            if (newStorage != oldOrNewStorage || !logger.isLoggable(Level.WARNING)) {
                return (I)oldOrNewStorage;
            }
            storages = new ArrayList<MetricStorage>(this.registry.values());
        }
        for (MetricStorage storage : storages) {
            MetricDescriptor existing;
            if (storage == newStorage || !(existing = storage.getMetricDescriptor()).getName().equalsIgnoreCase(descriptor.getName())) continue;
            logger.log(Level.WARNING, DebugUtils.duplicateMetricErrorMessage(existing, descriptor));
            break;
        }
        return (I)oldOrNewStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForTest() {
        Object object = this.lock;
        synchronized (object) {
            this.registry.clear();
        }
    }
}

