/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.caffeine;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class CacheMetricsCollector
implements MultiCollector {
    private static final double NANOSECONDS_PER_SECOND = 1.0E9;
    private static final String METRIC_NAME_CACHE_HIT = "caffeine_cache_hit";
    private static final String METRIC_NAME_CACHE_MISS = "caffeine_cache_miss";
    private static final String METRIC_NAME_CACHE_REQUESTS = "caffeine_cache_requests";
    private static final String METRIC_NAME_CACHE_EVICTION = "caffeine_cache_eviction";
    private static final String METRIC_NAME_CACHE_EVICTION_WEIGHT = "caffeine_cache_eviction_weight";
    private static final String METRIC_NAME_CACHE_LOAD_FAILURE = "caffeine_cache_load_failure";
    private static final String METRIC_NAME_CACHE_LOADS = "caffeine_cache_loads";
    private static final String METRIC_NAME_CACHE_ESTIMATED_SIZE = "caffeine_cache_estimated_size";
    private static final String METRIC_NAME_CACHE_WEIGHTED_SIZE = "caffeine_cache_weighted_size";
    private static final String METRIC_NAME_CACHE_LOAD_DURATION_SECONDS = "caffeine_cache_load_duration_seconds";
    private static final List<String> ALL_METRIC_NAMES = Collections.unmodifiableList(Arrays.asList("caffeine_cache_hit", "caffeine_cache_miss", "caffeine_cache_requests", "caffeine_cache_eviction", "caffeine_cache_eviction_weight", "caffeine_cache_load_failure", "caffeine_cache_loads", "caffeine_cache_estimated_size", "caffeine_cache_weighted_size", "caffeine_cache_load_duration_seconds"));
    protected final ConcurrentMap<String, Cache<?, ?>> children = new ConcurrentHashMap();
    private final boolean collectEvictionWeightAsCounter;
    private final boolean collectWeightedSize;

    @Deprecated
    public CacheMetricsCollector() {
        this(false, false);
    }

    protected CacheMetricsCollector(boolean collectEvictionWeightAsCounter, boolean collectWeightedSize) {
        this.collectEvictionWeightAsCounter = collectEvictionWeightAsCounter;
        this.collectWeightedSize = collectWeightedSize;
    }

    public void addCache(String cacheName, Cache<?, ?> cache) {
        this.children.put(cacheName, cache);
    }

    public void addCache(String cacheName, AsyncCache<?, ?> cache) {
        this.children.put(cacheName, cache.synchronous());
    }

    public Cache<?, ?> removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    public MetricSnapshots collect() {
        MetricSnapshots.Builder metricSnapshotsBuilder = MetricSnapshots.builder();
        List<String> labelNames = Arrays.asList("cache");
        CounterSnapshot.Builder cacheHitTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_HIT)).help("Cache hit totals");
        CounterSnapshot.Builder cacheMissTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_MISS)).help("Cache miss totals");
        CounterSnapshot.Builder cacheRequestsTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_REQUESTS)).help("Cache request totals, hits + misses");
        CounterSnapshot.Builder cacheEvictionTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_EVICTION)).help("Cache eviction totals, doesn't include manually removed entries");
        CounterSnapshot.Builder cacheEvictionWeight = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_EVICTION_WEIGHT)).help("Weight of evicted cache entries, doesn't include manually removed entries");
        GaugeSnapshot.Builder cacheEvictionWeightLegacyGauge = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(METRIC_NAME_CACHE_EVICTION_WEIGHT)).help("Weight of evicted cache entries, doesn't include manually removed entries");
        CounterSnapshot.Builder cacheLoadFailure = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_LOAD_FAILURE)).help("Cache load failures");
        CounterSnapshot.Builder cacheLoadTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_LOADS)).help("Cache loads: both success and failures");
        GaugeSnapshot.Builder cacheSize = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(METRIC_NAME_CACHE_ESTIMATED_SIZE)).help("Estimated cache size");
        GaugeSnapshot.Builder cacheWeightedSize = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(METRIC_NAME_CACHE_WEIGHTED_SIZE)).help("Approximate accumulated weight of cache entries");
        SummarySnapshot.Builder cacheLoadSummary = (SummarySnapshot.Builder)((SummarySnapshot.Builder)SummarySnapshot.builder().name(METRIC_NAME_CACHE_LOAD_DURATION_SECONDS)).help("Cache load duration: both success and failures");
        for (Map.Entry c : this.children.entrySet()) {
            Optional eviction;
            List<String> cacheName = Collections.singletonList((String)c.getKey());
            Labels labels = Labels.of(labelNames, cacheName);
            CacheStats stats = ((Cache)c.getValue()).stats();
            try {
                cacheEvictionWeight.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.evictionWeight()).build());
                cacheEvictionWeightLegacyGauge.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().labels(labels)).value((double)stats.evictionWeight()).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.collectWeightedSize && (eviction = ((Cache)c.getValue()).policy().eviction()).isPresent() && ((Policy.Eviction)eviction.get()).weightedSize().isPresent()) {
                cacheWeightedSize.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().labels(labels)).value((double)((Policy.Eviction)eviction.get()).weightedSize().getAsLong()).build());
            }
            cacheHitTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.hitCount()).build());
            cacheMissTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.missCount()).build());
            cacheRequestsTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.requestCount()).build());
            cacheEvictionTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.evictionCount()).build());
            cacheSize.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().labels(labels)).value((double)((Cache)c.getValue()).estimatedSize()).build());
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.loadFailureCount()).build());
            cacheLoadTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.loadCount()).build());
            cacheLoadSummary.dataPoint(((SummarySnapshot.SummaryDataPointSnapshot.Builder)((SummarySnapshot.SummaryDataPointSnapshot.Builder)SummarySnapshot.SummaryDataPointSnapshot.builder().labels(labels)).count(stats.loadCount()).sum((double)stats.totalLoadTime() / 1.0E9)).build());
        }
        if (this.collectWeightedSize) {
            metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheWeightedSize.build());
        }
        return metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheHitTotal.build()).metricSnapshot((MetricSnapshot)cacheMissTotal.build()).metricSnapshot((MetricSnapshot)cacheRequestsTotal.build()).metricSnapshot((MetricSnapshot)cacheEvictionTotal.build()).metricSnapshot((MetricSnapshot)(this.collectEvictionWeightAsCounter ? cacheEvictionWeight.build() : cacheEvictionWeightLegacyGauge.build())).metricSnapshot((MetricSnapshot)cacheLoadFailure.build()).metricSnapshot((MetricSnapshot)cacheLoadTotal.build()).metricSnapshot((MetricSnapshot)cacheSize.build()).metricSnapshot((MetricSnapshot)cacheLoadSummary.build()).build();
    }

    public List<String> getPrometheusNames() {
        if (!this.collectWeightedSize) {
            return ALL_METRIC_NAMES.stream().filter(s -> !METRIC_NAME_CACHE_WEIGHTED_SIZE.equals(s)).collect(Collectors.toList());
        }
        return ALL_METRIC_NAMES;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean collectEvictionWeightAsCounter = true;
        private boolean collectWeightedSize = true;

        public Builder collectEvictionWeightAsCounter(boolean collectEvictionWeightAsCounter) {
            this.collectEvictionWeightAsCounter = collectEvictionWeightAsCounter;
            return this;
        }

        public Builder collectWeightedSize(boolean collectWeightedSize) {
            this.collectWeightedSize = collectWeightedSize;
            return this;
        }

        public CacheMetricsCollector build() {
            return new CacheMetricsCollector(this.collectEvictionWeightAsCounter, this.collectWeightedSize);
        }
    }
}

