/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.guava;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheMetricsCollector
implements MultiCollector {
    private static final double NANOSECONDS_PER_SECOND = 1.0E9;
    private static final String METRIC_NAME_CACHE_HIT = "guava_cache_hit";
    private static final String METRIC_NAME_CACHE_MISS = "guava_cache_miss";
    private static final String METRIC_NAME_CACHE_REQUESTS = "guava_cache_requests";
    private static final String METRIC_NAME_CACHE_EVICTION = "guava_cache_eviction";
    private static final String METRIC_NAME_CACHE_LOAD_FAILURE = "guava_cache_load_failure";
    private static final String METRIC_NAME_CACHE_LOADS = "guava_cache_loads";
    private static final String METRIC_NAME_CACHE_SIZE = "guava_cache_size";
    private static final String METRIC_NAME_CACHE_LOAD_DURATION_SECONDS = "guava_cache_load_duration_seconds";
    private static final List<String> ALL_METRIC_NAMES = Collections.unmodifiableList(Arrays.asList("guava_cache_hit", "guava_cache_miss", "guava_cache_requests", "guava_cache_eviction", "guava_cache_load_failure", "guava_cache_loads", "guava_cache_size", "guava_cache_load_duration_seconds"));
    protected final ConcurrentMap<String, Cache<?, ?>> children = new ConcurrentHashMap();

    public void addCache(String cacheName, Cache<?, ?> cache) {
        this.children.put(cacheName, cache);
    }

    public Cache<?, ?> removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    public MetricSnapshots collect() {
        MetricSnapshots.Builder metricSnapshotsBuilder = MetricSnapshots.builder();
        List<String> labelNames = Collections.singletonList("cache");
        CounterSnapshot.Builder cacheHitTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_HIT)).help("Cache hit totals");
        CounterSnapshot.Builder cacheMissTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_MISS)).help("Cache miss totals");
        CounterSnapshot.Builder cacheRequestsTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_REQUESTS)).help("Cache request totals");
        CounterSnapshot.Builder cacheEvictionTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_EVICTION)).help("Cache eviction totals, doesn't include manually removed entries");
        CounterSnapshot.Builder cacheLoadFailure = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_LOAD_FAILURE)).help("Cache load failures");
        CounterSnapshot.Builder cacheLoadTotal = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(METRIC_NAME_CACHE_LOADS)).help("Cache loads: both success and failures");
        GaugeSnapshot.Builder cacheSize = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(METRIC_NAME_CACHE_SIZE)).help("Cache size");
        SummarySnapshot.Builder cacheLoadSummary = (SummarySnapshot.Builder)((SummarySnapshot.Builder)SummarySnapshot.builder().name(METRIC_NAME_CACHE_LOAD_DURATION_SECONDS)).help("Cache load duration: both success and failures");
        for (Map.Entry c : this.children.entrySet()) {
            List<String> cacheName = Collections.singletonList((String)c.getKey());
            Labels labels = Labels.of(labelNames, cacheName);
            CacheStats stats = ((Cache)c.getValue()).stats();
            cacheHitTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.hitCount()).build());
            cacheMissTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.missCount()).build());
            cacheRequestsTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.requestCount()).build());
            cacheEvictionTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.evictionCount()).build());
            cacheSize.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().labels(labels)).value((double)((Cache)c.getValue()).size()).build());
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.loadExceptionCount()).build());
            cacheLoadTotal.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value((double)stats.loadCount()).build());
            cacheLoadSummary.dataPoint(((SummarySnapshot.SummaryDataPointSnapshot.Builder)((SummarySnapshot.SummaryDataPointSnapshot.Builder)SummarySnapshot.SummaryDataPointSnapshot.builder().labels(labels)).count(stats.loadCount()).sum((double)stats.totalLoadTime() / 1.0E9)).build());
        }
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheHitTotal.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheMissTotal.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheRequestsTotal.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheEvictionTotal.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheLoadFailure.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheLoadTotal.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheSize.build());
        metricSnapshotsBuilder.metricSnapshot((MetricSnapshot)cacheLoadSummary.build());
        return metricSnapshotsBuilder.build();
    }

    public List<String> getPrometheusNames() {
        return ALL_METRIC_NAMES;
    }
}

