/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hibernate;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;

public class HibernateStatisticsCollector
extends Collector {
    private static final List<String> LABEL_NAMES = Collections.singletonList("unit");
    private static final List<String> LABEL_NAMES_PER_QUERY = Arrays.asList("unit", "query");
    private final Map<String, SessionFactory> sessionFactories = new ConcurrentHashMap<String, SessionFactory>();
    private boolean perQueryMetricsEnabled;

    public HibernateStatisticsCollector() {
    }

    public HibernateStatisticsCollector(SessionFactory sessionFactory, String name) {
        this.add(sessionFactory, name);
    }

    public HibernateStatisticsCollector add(SessionFactory sessionFactory, String name) {
        this.sessionFactories.put(name, sessionFactory);
        return this;
    }

    public HibernateStatisticsCollector enablePerQueryMetrics() {
        this.perQueryMetricsEnabled = true;
        return this;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> metrics = new ArrayList<Collector.MetricFamilySamples>();
        metrics.addAll(this.getSessionMetrics());
        metrics.addAll(this.getConnectionMetrics());
        metrics.addAll(this.getCacheMetrics());
        metrics.addAll(this.getEntityMetrics());
        metrics.addAll(this.getQueryExecutionMetrics());
        if (this.perQueryMetricsEnabled) {
            metrics.addAll(this.getPerQueryMetrics());
        }
        return metrics;
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        if (this.sessionFactories.isEmpty()) {
            throw new IllegalStateException("You must register at least one SessionFactory.");
        }
        return (T)super.register(registry);
    }

    private List<Collector.MetricFamilySamples> getSessionMetrics() {
        return Arrays.asList(this.createCounter("hibernate_session_opened_total", "Global number of sessions opened (getSessionOpenCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSessionOpenCount();
            }
        }), this.createCounter("hibernate_session_closed_total", "Global number of sessions closed (getSessionCloseCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSessionCloseCount();
            }
        }), this.createCounter("hibernate_flushed_total", "The global number of flushes executed by sessions (getFlushCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getFlushCount();
            }
        }), this.createCounter("hibernate_connect_total", "The global number of connections requested by the sessions (getConnectCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getConnectCount();
            }
        }), this.createCounter("hibernate_optimistic_failure_total", "The number of StaleObjectStateExceptions that occurred (getOptimisticFailureCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getOptimisticFailureCount();
            }
        }));
    }

    private List<Collector.MetricFamilySamples> getConnectionMetrics() {
        return Arrays.asList(this.createCounter("hibernate_statement_prepared_total", "The number of prepared statements that were acquired (getPrepareStatementCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getPrepareStatementCount();
            }
        }), this.createCounter("hibernate_statement_closed_total", "The number of prepared statements that were released (getCloseStatementCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCloseStatementCount();
            }
        }), this.createCounter("hibernate_transaction_total", "The number of transactions we know to have completed (getTransactionCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getTransactionCount();
            }
        }), this.createCounter("hibernate_transaction_success_total", "The number of transactions we know to have been successful (getSuccessfulTransactionCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSuccessfulTransactionCount();
            }
        }));
    }

    private List<Collector.MetricFamilySamples> getCacheMetrics() {
        return Arrays.asList(this.createCounter("hibernate_second_level_cache_hit_total", "Global number of cacheable entities/collections successfully retrieved from the cache (getSecondLevelCacheHitCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSecondLevelCacheHitCount();
            }
        }), this.createCounter("hibernate_second_level_cache_miss_total", "Global number of cacheable entities/collections not found in the cache and loaded from the database (getSecondLevelCacheMissCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSecondLevelCacheMissCount();
            }
        }), this.createCounter("hibernate_second_level_cache_put_total", "Global number of cacheable entities/collections put in the cache (getSecondLevelCachePutCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getSecondLevelCachePutCount();
            }
        }), this.createCounter("hibernate_query_cache_hit_total", "The global number of cached queries successfully retrieved from cache (getQueryCacheHitCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getQueryCacheHitCount();
            }
        }), this.createCounter("hibernate_query_cache_miss_total", "The global number of cached queries not found in cache (getQueryCacheMissCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getQueryCacheMissCount();
            }
        }), this.createCounter("hibernate_query_cache_put_total", "The global number of cacheable queries put in cache (getQueryCachePutCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getQueryCachePutCount();
            }
        }), this.createCounter("hibernate_natural_id_cache_hit_total", "The global number of cached naturalId lookups successfully retrieved from cache (getNaturalIdCacheHitCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getNaturalIdCacheHitCount();
            }
        }), this.createCounter("hibernate_natural_id_cache_miss_total", "The global number of cached naturalId lookups not found in cache (getNaturalIdCacheMissCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getNaturalIdCacheMissCount();
            }
        }), this.createCounter("hibernate_natural_id_cache_put_total", "The global number of cacheable naturalId lookups put in cache (getNaturalIdCachePutCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getNaturalIdCachePutCount();
            }
        }), this.createCounter("hibernate_update_timestamps_cache_hit_total", "The global number of timestamps successfully retrieved from cache (getUpdateTimestampsCacheHitCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getUpdateTimestampsCacheHitCount();
            }
        }), this.createCounter("hibernate_update_timestamps_cache_miss_total", "The global number of tables for which no update timestamps was not found in cache (getUpdateTimestampsCacheMissCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getUpdateTimestampsCacheMissCount();
            }
        }), this.createCounter("hibernate_update_timestamps_cache_put_total", "The global number of timestamps put in cache (getUpdateTimestampsCachePutCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getUpdateTimestampsCachePutCount();
            }
        }));
    }

    private List<Collector.MetricFamilySamples> getEntityMetrics() {
        return Arrays.asList(this.createCounter("hibernate_entity_delete_total", "Global number of entity deletes (getEntityDeleteCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getEntityDeleteCount();
            }
        }), this.createCounter("hibernate_entity_insert_total", "Global number of entity inserts (getEntityInsertCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getEntityInsertCount();
            }
        }), this.createCounter("hibernate_entity_load_total", "Global number of entity loads (getEntityLoadCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getEntityLoadCount();
            }
        }), this.createCounter("hibernate_entity_fetch_total", "Global number of entity fetches (getEntityFetchCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getEntityFetchCount();
            }
        }), this.createCounter("hibernate_entity_update_total", "Global number of entity updates (getEntityUpdateCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getEntityUpdateCount();
            }
        }), this.createCounter("hibernate_collection_load_total", "Global number of collections loaded (getCollectionLoadCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCollectionLoadCount();
            }
        }), this.createCounter("hibernate_collection_fetch_total", "Global number of collections fetched (getCollectionFetchCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCollectionFetchCount();
            }
        }), this.createCounter("hibernate_collection_update_total", "Global number of collections updated (getCollectionUpdateCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCollectionUpdateCount();
            }
        }), this.createCounter("hibernate_collection_remove_total", "Global number of collections removed (getCollectionRemoveCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCollectionRemoveCount();
            }
        }), this.createCounter("hibernate_collection_recreate_total", "Global number of collections recreated (getCollectionRecreateCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getCollectionRecreateCount();
            }
        }));
    }

    private List<Collector.MetricFamilySamples> getQueryExecutionMetrics() {
        return Arrays.asList(this.createCounter("hibernate_query_execution_total", "Global number of executed queries (getQueryExecutionCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getQueryExecutionCount();
            }
        }), this.createCounter("hibernate_natural_id_query_execution_total", "The global number of naturalId queries executed against the database (getNaturalIdQueryExecutionCount)", new ValueProvider(){

            @Override
            public double getValue(Statistics statistics) {
                return statistics.getNaturalIdQueryExecutionCount();
            }
        }));
    }

    private List<Collector.MetricFamilySamples> getPerQueryMetrics() {
        ArrayList<Collector.MetricFamilySamples> metrics = new ArrayList<Collector.MetricFamilySamples>();
        metrics.addAll(Arrays.asList(this.createCounterForQuery("hibernate_per_query_cache_hit_total", "Global number of cache hits for query (getCacheHitCount)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return statistics.getQueryStatistics(query).getCacheHitCount();
            }
        }), this.createCounterForQuery("hibernate_per_query_cache_miss_total", "Global number of cache misses for query (getCacheMissCount)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return statistics.getQueryStatistics(query).getCacheMissCount();
            }
        }), this.createCounterForQuery("hibernate_per_query_cache_put_total", "Global number of cache puts for query (getCachePutCount)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return statistics.getQueryStatistics(query).getCachePutCount();
            }
        }), this.createCounterForQuery("hibernate_per_query_execution_total", "Global number of executions for query (getExecutionCount)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return statistics.getQueryStatistics(query).getExecutionCount();
            }
        }), this.createCounterForQuery("hibernate_per_query_execution_rows_total", "Global number of rows for all executions of query (getExecutionRowCount)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return statistics.getQueryStatistics(query).getExecutionRowCount();
            }
        }), this.createGaugeForQuery("hibernate_per_query_execution_min_seconds", "Minimum execution time of query in seconds (based on getExecutionMinTime)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return HibernateStatisticsCollector.this.toSeconds(statistics.getQueryStatistics(query).getExecutionMinTime());
            }
        }), this.createGaugeForQuery("hibernate_per_query_execution_max_seconds", "Maximum execution time of query in seconds (based on getExecutionMaxTime)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return HibernateStatisticsCollector.this.toSeconds(statistics.getQueryStatistics(query).getExecutionMaxTime());
            }
        }), this.createCounterForQuery("hibernate_per_query_execution_seconds_total", "Accumulated execution time of query in seconds (based on getExecutionTotalTime)", new ValueProviderPerQuery(){

            @Override
            public double getValue(Statistics statistics, String query) {
                return HibernateStatisticsCollector.this.toSeconds(statistics.getQueryStatistics(query).getExecutionTotalTime());
            }
        })));
        return metrics;
    }

    private CounterMetricFamily createCounter(String metric, String help, ValueProvider provider) {
        CounterMetricFamily metricFamily = new CounterMetricFamily(metric, help, LABEL_NAMES);
        for (Map.Entry<String, SessionFactory> entry : this.sessionFactories.entrySet()) {
            metricFamily.addMetric(Collections.singletonList(entry.getKey()), provider.getValue(entry.getValue().getStatistics()));
        }
        return metricFamily;
    }

    private CounterMetricFamily createCounterForQuery(String metric, String help, ValueProviderPerQuery provider) {
        final CounterMetricFamily counters = new CounterMetricFamily(metric, help, LABEL_NAMES_PER_QUERY);
        this.addMetricsForQuery(new PerQuerySamples(){

            @Override
            public void addMetric(List<String> labelValues, double value) {
                counters.addMetric(labelValues, value);
            }
        }, provider);
        return counters;
    }

    private GaugeMetricFamily createGaugeForQuery(String metric, String help, ValueProviderPerQuery provider) {
        final GaugeMetricFamily gauges = new GaugeMetricFamily(metric, help, LABEL_NAMES_PER_QUERY);
        this.addMetricsForQuery(new PerQuerySamples(){

            @Override
            public void addMetric(List<String> labelValues, double value) {
                gauges.addMetric(labelValues, value);
            }
        }, provider);
        return gauges;
    }

    private void addMetricsForQuery(PerQuerySamples samples, ValueProviderPerQuery provider) {
        for (Map.Entry<String, SessionFactory> entry : this.sessionFactories.entrySet()) {
            SessionFactory sessionFactory = entry.getValue();
            Statistics stats = sessionFactory.getStatistics();
            String unitName = entry.getKey();
            for (String query : stats.getQueries()) {
                samples.addMetric(Arrays.asList(unitName, query), provider.getValue(stats, query));
            }
        }
    }

    private double toSeconds(long milliseconds) {
        return (double)milliseconds / 1000.0;
    }

    private static interface ValueProviderPerQuery {
        public double getValue(Statistics var1, String var2);
    }

    private static interface ValueProvider {
        public double getValue(Statistics var1);
    }

    private static interface PerQuerySamples {
        public void addMetric(List<String> var1, double var2);
    }
}

