/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.servlet.jakarta.filter;

import io.prometheus.client.servlet.common.filter.Filter;
import io.prometheus.client.servlet.common.filter.FilterConfigurationException;
import io.prometheus.client.servlet.jakarta.Adapter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MetricsFilter
implements jakarta.servlet.Filter {
    private final Filter delegate;

    public MetricsFilter() {
        this.delegate = new Filter();
    }

    public MetricsFilter(String metricName, String help, Integer pathComponents, double[] buckets, boolean stripContextPath) {
        this.delegate = new Filter(metricName, help, pathComponents, buckets, stripContextPath);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.delegate.init(Adapter.wrap(filterConfig));
        }
        catch (FilterConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        Filter.MetricData data = this.delegate.startTimer(Adapter.wrap((HttpServletRequest)servletRequest));
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.delegate.observeDuration(data, Adapter.wrap((HttpServletResponse)servletResponse));
        }
    }

    public void destroy() {
    }
}

