/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber6jvm;

import io.cucumber.messages.Messages;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.cucumber6jvm.LabelBuilder;
import io.qameta.allure.cucumber6jvm.TagParser;
import io.qameta.allure.cucumber6jvm.testsourcemodel.TestSourcesModelProxy;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AllureCucumber6Jvm
implements ConcurrentEventListener {
    private final AllureLifecycle lifecycle;
    private final ConcurrentHashMap<String, String> scenarioUuids = new ConcurrentHashMap();
    private final TestSourcesModelProxy testSources = new TestSourcesModelProxy();
    private final ThreadLocal<Messages.GherkinDocument.Feature> currentFeature = new InheritableThreadLocal<Messages.GherkinDocument.Feature>();
    private final ThreadLocal<URI> currentFeatureFile = new InheritableThreadLocal<URI>();
    private final ThreadLocal<TestCase> currentTestCase = new InheritableThreadLocal<TestCase>();
    private final ThreadLocal<String> currentContainer = new InheritableThreadLocal<String>();
    private final ThreadLocal<Boolean> forbidTestCaseStatusChange = new InheritableThreadLocal<Boolean>();
    private final EventHandler<TestSourceRead> featureStartedHandler = this::handleFeatureStartedHandler;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private final EventHandler<WriteEvent> writeEventHandler = this::handleWriteEvent;
    private final EventHandler<EmbedEvent> embedEventHandler = this::handleEmbedEvent;
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";

    public AllureCucumber6Jvm() {
        this(Allure.getLifecycle());
    }

    public AllureCucumber6Jvm(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.featureStartedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
    }

    private void handleFeatureStartedHandler(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        String description;
        this.currentFeatureFile.set(event.getTestCase().getUri());
        this.currentFeature.set(this.testSources.getFeature(this.currentFeatureFile.get()));
        this.currentTestCase.set(event.getTestCase());
        this.currentContainer.set(UUID.randomUUID().toString());
        this.forbidTestCaseStatusChange.set(false);
        LinkedList<String> tags = new LinkedList<String>(this.currentTestCase.get().getTags());
        Messages.GherkinDocument.Feature feature = this.currentFeature.get();
        LabelBuilder labelBuilder = new LabelBuilder(feature, this.currentTestCase.get(), tags);
        String name = this.currentTestCase.get().getName();
        String featureName = feature.getName();
        TestResult result = new TestResult().setUuid(this.getTestCaseUuid(this.currentTestCase.get())).setHistoryId(this.getHistoryId(this.currentTestCase.get())).setFullName(featureName + ": " + name).setName(name).setLabels(labelBuilder.getScenarioLabels()).setLinks(labelBuilder.getScenarioLinks());
        Messages.GherkinDocument.Feature.Scenario scenarioDefinition = this.testSources.getScenarioDefinition(this.currentFeatureFile.get(), this.currentTestCase.get().getLine());
        if (scenarioDefinition.getExamplesCount() > 0) {
            result.setParameters(this.getExamplesAsParameters(scenarioDefinition, this.currentTestCase.get()));
        }
        if (!(description = Stream.of(feature.getDescription(), scenarioDefinition.getDescription()).filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"))).isEmpty()) {
            result.setDescription(description);
        }
        TestResultContainer resultContainer = new TestResultContainer().setName(String.format("%s: %s", scenarioDefinition.getKeyword(), scenarioDefinition.getName())).setUuid(this.getTestContainerUuid()).setChildren(Collections.singletonList(this.getTestCaseUuid(this.currentTestCase.get())));
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestContainer(this.getTestContainerUuid(), resultContainer);
        this.lifecycle.startTestCase(this.getTestCaseUuid(this.currentTestCase.get()));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String uuid = this.getTestCaseUuid(event.getTestCase());
        Optional details = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError());
        details.ifPresent(statusDetails -> this.lifecycle.updateTestCase(uuid, testResult -> testResult.setStatusDetails(statusDetails)));
        this.lifecycle.stopTestCase(uuid);
        this.lifecycle.stopTestContainer(this.getTestContainerUuid());
        this.lifecycle.writeTestCase(uuid);
        this.lifecycle.writeTestContainer(this.getTestContainerUuid());
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)event.getTestStep();
            String stepKeyword = Optional.ofNullable(this.testSources.getKeywordFromSource(this.currentFeatureFile.get(), pickleStep.getStep().getLine())).orElse("UNDEFINED");
            StepResult stepResult = new StepResult().setName(String.format("%s %s", stepKeyword, pickleStep.getStep().getText())).setStart(Long.valueOf(System.currentTimeMillis()));
            this.lifecycle.startStep(this.getTestCaseUuid(this.currentTestCase.get()), this.getStepUuid(pickleStep), stepResult);
            StepArgument stepArgument = pickleStep.getStep().getArgument();
            if (stepArgument instanceof DataTableArgument) {
                DataTableArgument dataTableArgument = (DataTableArgument)stepArgument;
                this.createDataTableAttachment(dataTableArgument);
            }
        } else if (event.getTestStep() instanceof HookTestStep) {
            this.initHook((HookTestStep)event.getTestStep());
        }
    }

    private void initHook(HookTestStep hook) {
        FixtureResult hookResult = new FixtureResult().setName(hook.getCodeLocation()).setStart(Long.valueOf(System.currentTimeMillis()));
        if (hook.getHookType() == HookType.BEFORE) {
            this.lifecycle.startPrepareFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        } else {
            this.lifecycle.startTearDownFixture(this.getTestContainerUuid(), this.getHookStepUuid(hook), hookResult);
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof HookTestStep) {
            this.handleHookStep(event);
        } else {
            this.handlePickleStep(event);
        }
    }

    private void handleWriteEvent(WriteEvent event) {
        this.lifecycle.addAttachment("Text output", TEXT_PLAIN, TXT_EXTENSION, Objects.toString(event.getText()).getBytes(StandardCharsets.UTF_8));
    }

    private void handleEmbedEvent(EmbedEvent event) {
        this.lifecycle.addAttachment(event.name, event.getMediaType(), null, (InputStream)new ByteArrayInputStream(event.getData()));
    }

    private String getTestContainerUuid() {
        return this.currentContainer.get();
    }

    private String getTestCaseUuid(TestCase testCase) {
        return this.scenarioUuids.computeIfAbsent(this.getHistoryId(testCase), it -> UUID.randomUUID().toString());
    }

    private String getStepUuid(PickleStepTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getStep().getText() + step.getStep().getLine();
    }

    private String getHookStepUuid(HookTestStep step) {
        return this.currentFeature.get().getName() + this.getTestCaseUuid(this.currentTestCase.get()) + step.getHookType().toString() + step.getCodeLocation();
    }

    private String getHistoryId(TestCase testCase) {
        String testCaseLocation = testCase.getUri().toString().substring(testCase.getUri().toString().lastIndexOf(47) + 1) + ":" + testCase.getLine();
        return ResultsUtils.md5((String)testCaseLocation);
    }

    private Status translateTestCaseStatus(Result testCaseResult) {
        switch (testCaseResult.getStatus()) {
            case FAILED: {
                return ResultsUtils.getStatus((Throwable)testCaseResult.getError()).orElse(Status.FAILED);
            }
            case PASSED: {
                return Status.PASSED;
            }
            case SKIPPED: 
            case PENDING: {
                return Status.SKIPPED;
            }
        }
        return null;
    }

    private List<Parameter> getExamplesAsParameters(Messages.GherkinDocument.Feature.Scenario scenario, TestCase localCurrentTestCase) {
        Optional<Messages.GherkinDocument.Feature.Scenario.Examples> examplesBlock = scenario.getExamplesList().stream().filter(example -> example.getTableBodyList().stream().anyMatch(row -> row.getLocation().getLine() == localCurrentTestCase.getLine().intValue())).findFirst();
        if (examplesBlock.isPresent()) {
            Messages.GherkinDocument.Feature.TableRow row = examplesBlock.get().getTableBodyList().stream().filter(example -> example.getLocation().getLine() == localCurrentTestCase.getLine().intValue()).findFirst().get();
            return IntStream.range(0, examplesBlock.get().getTableHeader().getCellsList().size()).mapToObj(index -> {
                String name = ((Messages.GherkinDocument.Feature.TableRow.TableCell)((Messages.GherkinDocument.Feature.Scenario.Examples)examplesBlock.get()).getTableHeader().getCellsList().get(index)).getValue();
                String value = ((Messages.GherkinDocument.Feature.TableRow.TableCell)row.getCellsList().get(index)).getValue();
                return ResultsUtils.createParameter((String)name, (Object)value);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void createDataTableAttachment(DataTableArgument dataTableArgument) {
        List rowsInTable = dataTableArgument.cells();
        StringBuilder dataTableCsv = new StringBuilder();
        for (List columns : rowsInTable) {
            if (columns.isEmpty()) continue;
            for (int i = 0; i < columns.size(); ++i) {
                if (i == columns.size() - 1) {
                    dataTableCsv.append((String)columns.get(i));
                    continue;
                }
                dataTableCsv.append((String)columns.get(i));
                dataTableCsv.append('\t');
            }
            dataTableCsv.append('\n');
        }
        String attachmentSource = this.lifecycle.prepareAttachment("Data table", "text/tab-separated-values", "csv");
        this.lifecycle.writeAttachment(attachmentSource, (InputStream)new ByteArrayInputStream(dataTableCsv.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private void handleHookStep(TestStepFinished event) {
        HookTestStep hookStep = (HookTestStep)event.getTestStep();
        String uuid = this.getHookStepUuid(hookStep);
        FixtureResult fixtureResult = new FixtureResult().setStatus(this.translateTestCaseStatus(event.getResult()));
        if (!Status.PASSED.equals((Object)fixtureResult.getStatus())) {
            TestResult testResult = new TestResult().setStatus(this.translateTestCaseStatus(event.getResult()));
            StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError()).orElseGet(StatusDetails::new);
            String errorMessage = event.getResult().getError() == null ? hookStep.getHookType().name() + " is failed." : hookStep.getHookType().name() + " is failed: " + event.getResult().getError().getLocalizedMessage();
            statusDetails.setMessage(errorMessage);
            if (hookStep.getHookType() == HookType.BEFORE) {
                TagParser tagParser = new TagParser(this.currentFeature.get(), this.currentTestCase.get());
                statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
                testResult.setStatus(Status.SKIPPED);
                this.updateTestCaseStatus(testResult.getStatus());
                this.forbidTestCaseStatusChange.set(true);
            } else {
                testResult.setStatus(Status.BROKEN);
                this.updateTestCaseStatus(testResult.getStatus());
            }
            fixtureResult.setStatusDetails(statusDetails);
        }
        this.lifecycle.updateFixture(uuid, result -> result.setStatus(fixtureResult.getStatus()).setStatusDetails(fixtureResult.getStatusDetails()));
        this.lifecycle.stopFixture(uuid);
    }

    private void handlePickleStep(TestStepFinished event) {
        StatusDetails statusDetails;
        Status stepStatus = this.translateTestCaseStatus(event.getResult());
        if (event.getResult().getStatus() == io.cucumber.plugin.event.Status.UNDEFINED) {
            this.updateTestCaseStatus(Status.PASSED);
            statusDetails = ResultsUtils.getStatusDetails((Throwable)new IllegalStateException("Undefined Step. Please add step definition")).orElse(new StatusDetails());
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), scenarioResult -> scenarioResult.setStatusDetails(statusDetails));
        } else {
            statusDetails = ResultsUtils.getStatusDetails((Throwable)event.getResult().getError()).orElse(new StatusDetails());
            this.updateTestCaseStatus(stepStatus);
        }
        if (!Status.PASSED.equals((Object)stepStatus) && stepStatus != null) {
            this.forbidTestCaseStatusChange.set(true);
        }
        TagParser tagParser = new TagParser(this.currentFeature.get(), this.currentTestCase.get());
        statusDetails.setFlaky(tagParser.isFlaky()).setMuted(tagParser.isMuted()).setKnown(tagParser.isKnown());
        this.lifecycle.updateStep(this.getStepUuid((PickleStepTestStep)event.getTestStep()), stepResult -> stepResult.setStatus(stepStatus).setStatusDetails(statusDetails));
        this.lifecycle.stopStep(this.getStepUuid((PickleStepTestStep)event.getTestStep()));
    }

    private void updateTestCaseStatus(Status status) {
        if (!this.forbidTestCaseStatusChange.get().booleanValue()) {
            this.lifecycle.updateTestCase(this.getTestCaseUuid(this.currentTestCase.get()), result -> result.setStatus(status));
        }
    }
}

